package com.bxm.localnews.im.task;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.localnews.im.chat.IMService;
import lombok.extern.slf4j.Slf4j;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 私聊汇总监控任务
 */
@Component
@Slf4j
public class ChatMonitorTask implements ISimplifyElasticJob {

    @Resource
    private IMService imService;

    @Override
    public String cron() {
        return "0 0 22 * * ?";
    }

    @Override
    public String description() {
        return "即时通讯钉钉监控,对频繁发起私聊的用户进行监控,提醒运营重点监控对应的用户";
    }

    @Override
    public void execute(ShardingContext shardingContext) {
        log.info("即时通讯钉钉监控开始运行");
        imService.countAndPush();
    }
}
