package com.bxm.localnews.im.task;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.localnews.im.activity.RedPacketDetailService;
import com.bxm.localnews.im.domain.activity.RedpacketPlanDetailMapper;
import com.bxm.localnews.im.entity.activity.RedpacketPlanDetailEntity;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 定期清理没有被人领取的红包
 *
 * @author liujia
 * @date 10/13/21 2:40 PM
 **/
@Component
@AllArgsConstructor
@Slf4j
public class ClearUnReceiveRedPacketTask implements ISimplifyElasticJob {

    private RedpacketPlanDetailMapper redpacketPlanDetailMapper;

    private RedPacketDetailService redPacketDetailService;

    @Override
    public String cron() {
        return "0 0 2 * * ?";
    }

    @Override
    public String description() {
        return "定期清理没有被领取完的周期红包";
    }

    @Override
    public void execute(ShardingContext shardingContext) {
        // 查找每天
        Date lastReceiveDate = DateUtils.addField(new Date(), Calendar.DATE, -1);
        List<RedpacketPlanDetailEntity> expiredList = redpacketPlanDetailMapper.getReceiveRedpacket(lastReceiveDate);

        for (RedpacketPlanDetailEntity detailEntity : expiredList) {
            log.info("[{}]红包未领取完，强制结束", detailEntity.getId());

            redPacketDetailService.closePlanDetail(detailEntity.getId());
        }
    }
}
