package com.bxm.localnews.im.task;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.localnews.im.activity.RedPacketPlanService;
import lombok.AllArgsConstructor;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.springframework.stereotype.Component;

/**
 * @author liujia
 * @date 9/26/21 11:03 PM
 **/
@Component
@AllArgsConstructor
public class ScanRedpacketPlanTask implements ISimplifyElasticJob {

    private RedPacketPlanService redPacketPlanService;

    @Override
    public String cron() {
        return "0 0/5 * * * ?";
    }

    @Override
    public String description() {
        return "扫描红包计划，尝试进行激活";
    }

    @Override
    public void execute(ShardingContext shardingContext) {
        redPacketPlanService.processPlan();
    }
}
