package com.bxm.localnews.im.task;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.localnews.im.activity.RedPacketReminderService;
import lombok.AllArgsConstructor;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.springframework.stereotype.Component;

/**
 * @author liujia
 * @date 9/26/21 11:03 PM
 **/
@Component
@AllArgsConstructor
public class ScanRedpacketRemindTask implements ISimplifyElasticJob {

    private RedPacketReminderService redPacketReminderService;

    @Override
    public String cron() {
        return "0 0/1 * * * ?";
    }

    @Override
    public String description() {
        return "扫描红包的系统提示消息，发送到对应的群聊中";
    }

    @Override
    public void execute(ShardingContext shardingContext) {
        redPacketReminderService.processRemind();
    }
}
