package com.bxm.localnews.im.task;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.localnews.im.activity.RedPacketDetailService;
import lombok.AllArgsConstructor;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.springframework.stereotype.Component;

/**
 * 红包状态转变
 *
 * @author liujia
 * @date 9/26/21 11:03 PM
 **/
@Component
@AllArgsConstructor
public class ScanRedpacketStatusTask implements ISimplifyElasticJob {

    private RedPacketDetailService redPacketDetailService;

    @Override
    public String cron() {
        return "0 0/1 * * * ?";
    }

    @Override
    public String description() {
        return "将红包变更为可领取状态";
    }

    @Override
    public void execute(ShardingContext shardingContext) {
        redPacketDetailService.processStatusPlan();
    }
}
