package com.bxm.localnews.im.task;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.localnews.im.activity.RedPacketReminderService;
import lombok.AllArgsConstructor;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.springframework.stereotype.Component;

/**
 * @author liujia
 * @date 9/26/21 11:03 PM
 **/
@Component
@AllArgsConstructor
public class ScanRedpacketUserRemindTask implements ISimplifyElasticJob {

    private RedPacketReminderService redPacketReminderService;

    @Override
    public String cron() {
        return "0 0/5 * * * ?";
    }

    @Override
    public String description() {
        return "扫描待开始的红包，给订阅了的用户进行提醒";
    }

    @Override
    public void execute(ShardingContext shardingContext) {
        redPacketReminderService.processUserRemind();
    }
}
