/*
 * Copyright 2019 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.im.task;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.localnews.im.user.UserBlockService;
import com.bxm.localnews.im.vo.UserBlockBean;
import lombok.extern.slf4j.Slf4j;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * 重置用户的屏蔽状态
 */
@Component
@Slf4j
public class UnblockTask implements ISimplifyElasticJob {

    @Resource
    private UserBlockService userBlockService;

    @Override
    public String cron() {
        return "0 0/1 * * * ?";
    }

    @Override
    public String description() {
        return "重置用户屏蔽状态";
    }

    @Override
    public void execute(ShardingContext shardingContext) {
        List<UserBlockBean> expiredBlockList = userBlockService.getExpiredBlockList(new Date());

        for (UserBlockBean userBlockBean : expiredBlockList) {
            userBlockService.unblock(userBlockBean.getUserId());

        }
    }
}
