package com.bxm.localnews.im.thirdpart;

import com.bxm.egg.message.vo.UserInfoBean;
import com.bxm.localnews.im.param.MessageWithdrawParam;
import com.bxm.newidea.component.bo.Message;
import io.rong.messages.BaseMessage;
import io.rong.models.message.PrivateMessage;

import java.util.Date;

/**
 * 即时通讯SDK服务接口
 *
 * @author liujia
 */
public interface IMSDKAdapter {

    /**
     * 根据用户信息创建token
     *
     * @param user 用户信息
     * @return 客户端用于通讯的token
     */
    String token(UserInfoBean user);

    /**
     * 更新第三方存储的用户信息
     *
     * @param user 用户信息
     */
    void update(UserInfoBean user);

    /**
     * 封禁用户
     *
     * @param userId  用户ID
     * @param mintues 封禁时长
     * @return 操作结果
     */
    Message block(Long userId, int mintues);

    /**
     * 解除封禁
     *
     * @param userId 用户ID
     * @return 操作结果
     */
    Message unblock(Long userId);

    /**
     * 撤回消息
     *
     * @param param
     * @return
     */
    Message messageWithdraw(MessageWithdrawParam param);

    /**
     * 批量发送消息
     *
     * @param message
     * @return
     */
    Message batchSendPersonalMessage(PrivateMessage message);

    /**
     * 创建群组
     *
     * @param groupId 群组ID
     * @param name    群组名称
     * @return 创建结果
     */
    Message createGroup(Long groupId, String name, Long... manageMember);

    /**
     * 刷新群组信息
     *
     * @param groupId 群组ID
     * @param name    群组名称
     * @return 处理结果
     */
    Message refreshGroup(Long groupId, String name);

    /**
     * 用户加入群组
     *
     * @param groupId   群组ID
     * @param groupName 群组名称
     * @param memberIds 加入群组的成员ID
     * @return 处理结果
     */
    Message joinGroup(Long groupId, String groupName, Long... memberIds);

    /**
     * 退出群组
     *
     * @param groupId   群组ID
     * @param memberIds 退出群组的ID
     * @return 处理结果
     */
    Message quitGroup(Long groupId, Long... memberIds);

    /**
     * 群组成员禁言
     *
     * @param groupId   群组ID
     * @param memberId  群组成员ID
     * @param blockDate 禁言的截止时间
     * @return 处理结果
     */
    Message blockGroupMember(Long groupId, Long memberId, Date blockDate);

    /**
     * 群组成员解除禁言
     *
     * @param groupId  群组ID
     * @param memberId 群组成员ID
     * @return 处理结果
     */
    Message unblockGroupMember(Long groupId, Long memberId);

    /**
     * 发送群组消息
     *
     * @param groupId 接收消息的群组
     * @param forumId 发送消息的用户ID
     * @param message 发送的消息
     * @return 发送结果
     */
    Message sendGroupMessage(Long groupId, Long forumId, BaseMessage message);
}
