package com.bxm.localnews.im.thirdpart;

import com.bxm.localnews.im.thirdpart.enums.MsgTypeEnum;
import com.bxm.localnews.im.vo.IMMessageBean;

import java.util.Map;

public interface MsgContentProcesser {
    /**
     * 不同SDK的原始消息都有对应的特殊结构
     * 解析原始消息，提取其中的内容部分，用于消息推送和查询显示
     * @param source 原始信息
     * @return 简略信息，用于在消息列表、推送等显示
     */
    String parseBrief(String source);

    /**
     * 解析消息内容，获取其中的内容部分
     * @param source 原始信息
     * @return 消息中的内容，用于直接显示消息文本，提取消息中的图片、视频、音频地址
     */
    String parse(String source);

    /**
     * 构建一个特定消息类型的消息内容
     * @param rawMap 原始信息
     * @return 对应SDK的消息类型内容字符串
     */
    String build(Map<String, Object> rawMap);

    /**
     * 支持处理的消息类型
     * @return 消息类型
     */
    String type();

    /**
     * 当前消息处理器对应的消息类型
     * @return 消息类型
     */
    default MsgTypeEnum msgType() {
        return MsgTypeEnum.CONTENT;
    }

    /**
     * 如果是动作类消息，触发对应的回调函数进行逻辑处理
     */
    default void callback(IMMessageBean message) {
    }
}
