package com.bxm.localnews.im.thirdpart;

import com.bxm.localnews.im.thirdpart.rongcloud.DefaultProcesser;
import com.google.common.collect.Maps;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotNull;
import java.util.Map;

/**
 * 融云消息处理器工厂
 */
@Component
public class RCProcessorFactory implements InitializingBean, ApplicationContextAware {

    private static Map<String, MsgContentProcesser> processorMap = Maps.newHashMap();

    private ApplicationContext applicationContext;

    public static MsgContentProcesser get(String type) {
        MsgContentProcesser processor = processorMap.get(type);
        if (null == processor) {
            processor = new DefaultProcesser();
        }
        return processor;
    }

    @Override
    public void afterPropertiesSet() {
        Map<String, MsgContentProcesser> processorBeanMap = applicationContext.getBeansOfType(MsgContentProcesser.class);
        for (MsgContentProcesser processor : processorBeanMap.values()) {
            processorMap.put(processor.type(), processor);
        }
    }

    @Override
    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
