package com.bxm.localnews.im.thirdpart.message;

import com.bxm.newidea.component.JSON;
import io.rong.messages.BaseMessage;

/**
 * 自定义消息,对融云的消息和自定义的消息进行二次封装
 *
 * @author liujia
 */
public abstract class CustomMessage extends BaseMessage {
    /**
     * 消息类型
     */
    private String type;

    /**
     * 消息内容
     */
    protected String content;

    public CustomMessage(String type) {
        this.type = type;
    }

    public String getContent() {
        return content;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}