package com.bxm.localnews.im.thirdpart.message;

import com.bxm.newidea.component.JSON;
import lombok.Data;

/**
 * 自定义帖子消息
 *
 * @author Gonzo
 * @date 2019-10-31 18:53
 */
public class PostMessage extends CustomMessage {

    private PostMessage(String type) {
        super(type);
    }

    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    public static class MessageBuilder {

        private static final String TYPE = "LN:SharePost";

        private MessageContent contentObj = new MessageContent();

        private MessageBuilder() {
        }

        public MessageBuilder title(String title) {
            this.contentObj.title = title;
            return this;
        }

        public MessageBuilder content(String content) {
            this.contentObj.content = content;
            return this;
        }

        public MessageBuilder imgURL(String imgURL) {
            this.contentObj.imgURL = imgURL;
            return this;
        }

        public MessageBuilder url(String url) {
            this.contentObj.url = url;
            return this;
        }

        public PostMessage build() {
            PostMessage message = new PostMessage(TYPE);
            message.content = JSON.toJSONString(contentObj);
            return message;
        }
    }

    @Data
    public static class MessageContent {

        /**
         * {
         * "title": "",
         * "content": "可怕，太难了，又出现奇奇怪怪的bug",
         * "imgURL": "https://m.wstong.com/localnews_test/png/20191026/836678e5014584eb-20191026180118143-0.png?x-oss-process\u003dstyle/thumbnail",
         * "url": "wst://community/postDetail?postId\u003d4000000000020376\u0026tp\u003dpost"
         * }
         */
        private String title;

        private String content;

        private String imgURL;

        private String url;

        MessageContent() {

        }

    }
}

