package com.bxm.localnews.im.thirdpart.message;

import com.bxm.newidea.component.JSON;
import lombok.Data;

/**
 * 自定义红包消息
 *
 * @author Gonzo
 * @date 2019-10-31 18:53
 */
public class RedPacketMessage extends CustomMessage {

    private RedPacketMessage(String type) {
        super(type);
    }

    public static RedPacketMessageBuilder builder() {
        return new RedPacketMessageBuilder();
    }

    public static class RedPacketMessageBuilder {

        private static final String TYPE = "LN:RedPacket";

        private RedPacketMessageContent contentObj = new RedPacketMessageContent();

        private RedPacketMessageBuilder() {
        }

        public RedPacketMessageBuilder name(String name) {
            this.contentObj.name = name;
            return this;
        }

        public RedPacketMessageBuilder typeName(String typeName) {
            this.contentObj.typeName = typeName;
            return this;
        }

        public RedPacketMessageBuilder redPacketId(String redPacketId) {
            this.contentObj.redPacketId = redPacketId;
            return this;
        }

        public RedPacketMessage build() {
            RedPacketMessage message = new RedPacketMessage(TYPE);
            message.content = JSON.toJSONString(contentObj);
            return message;
        }
    }

    @Data
    public static class RedPacketMessageContent {

        /**
         * 红包名称
         */
        private String name;

        /**
         * 红包类型 eg：现金红包
         */
        private String typeName;

        /**
         * 红包id
         */
        private String redPacketId;

        RedPacketMessageContent() {

        }

    }
}

