package com.bxm.localnews.im.thirdpart.rongcloud;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 文件类型处理器
 * https://www.rongcloud.cn/docs/message_architecture.html#file_message
 */
@Component
public class FileProcesser extends AbstractRongCloudProcesser {
    @Override
    public String parseBrief(String source) {
        return "[文件]";
    }

    @Override
    public String parse(String source) {
        JSONObject json = parseToJson(source);
        return json.getString("fileUrl");
    }

    @Override
    public String build(Map<String, Object> rawMap) {
        return null;
    }

    @Override
    public String type() {
        return "RC:FileMsg";
    }
}
