package com.bxm.localnews.im.thirdpart.rongcloud;

import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * gif图片类型处理器
 * https://www.rongcloud.cn/docs/message_architecture.html#gifimage_message
 */
@Component
public class GifProcesser extends AbstractRongCloudProcesser {
    @Override
    public String parseBrief(String source) {
        return "[图片]";
    }

    @Override
    public String parse(String source) {
        return parseToJson(source).getString("remoteUrl");
    }

    @Override
    public String build(Map<String, Object> rawMap) {
        return null;
    }

    @Override
    public String type() {
        return "RC:GIFMsg";
    }
}
