package com.bxm.localnews.im.thirdpart.rongcloud;

import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 高清语音消息
 * https://www.rongcloud.cn/docs/message_architecture.html#hqvoice_message
 */
@Component
public class HqVoiceProcesser extends AbstractRongCloudProcesser {
    @Override
    public String parseBrief(String source) {
        return "[语音]";
    }

    @Override
    public String parse(String source) {
        return parseToJson(source).getString("remoteUrl");
    }

    @Override
    public String build(Map<String, Object> rawMap) {
        return null;
    }

    @Override
    public String type() {
        return "RC:HQVCMsg";
    }
}
