package com.bxm.localnews.im.thirdpart.rongcloud;

import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 图片类型处理器
 * https://www.rongcloud.cn/docs/message_architecture.html#image_message
 */
@Component
public class ImgProcesser extends AbstractRongCloudProcesser {
    @Override
    public String parseBrief(String source) {
        return "[图片]";
    }

    @Override
    public String parse(String source) {
        return parseToJson(source).getString("imageUri");
    }

    @Override
    public String build(Map<String, Object> rawMap) {
        return null;
    }

    @Override
    public String type() {
        return "RC:ImgMsg";
    }
}
