package com.bxm.localnews.im.thirdpart.rongcloud;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 位置信息类型处理器
 * https://www.rongcloud.cn/docs/message_architecture.html#location_message
 */
@Component
public class LBSProcesser extends AbstractRongCloudProcesser {
    @Override
    public String parseBrief(String source) {
        return "[位置信息]";
    }

    @Override
    public String parse(String source) {
        JSONObject json = parseToJson(source);
        String poi = json.getString("poi");
        if (StringUtils.isBlank(poi)) {
            Double lat = json.getDouble("latitude");
            Double lng = json.getDouble("longitude");
            return lat + "," + lng;
        }
        return poi;
    }

    @Override
    public String build(Map<String, Object> rawMap) {
        return null;
    }

    @Override
    public String type() {
        return "RC:LBSMsg";
    }
}
