package com.bxm.localnews.im.thirdpart.rongcloud;

import com.bxm.localnews.im.thirdpart.enums.MsgTypeEnum;
import com.bxm.localnews.im.vo.IMMessageBean;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 标记为消息已被客户端接收
 * https://www.rongcloud.cn/docs/message_architecture.html#read_receipt_message
 * @author liujia
 */
@Component
@Slf4j
public class MarkReceivedProcesser extends AbstractRongCloudProcesser {

    @Override
    public String parseBrief(String source) {
        return null;
    }

    @Override
    public String parse(String source) {
        return null;
    }

    @Override
    public String build(Map<String, Object> rawMap) {
        return null;
    }

    @Override
    public String type() {
        return "RC:ReadNtf";
    }

    @Override
    public MsgTypeEnum msgType() {
        return MsgTypeEnum.ACTION;
    }

    @Override
    public void callback(IMMessageBean message) {
        if (log.isDebugEnabled()) {
            log.debug("消息已被接收：" + message);
        }
    }
}
