package com.bxm.localnews.im.thirdpart.rongcloud;

import com.bxm.localnews.im.enums.ObjectNameEnum;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 实时位置共享的结束消息
 * https://www.rongcloud.cn/docs/message_architecture.html#framework_message_type
 */
@Component
public class RLEndProcesser extends AbstractRongCloudProcesser {

    @Override
    public String parseBrief(String source) {
        return "[共享位置结束消息]";
    }

    @Override
    public String parse(String source) {
        return "实时共享位置结束";
    }

    @Override
    public String build(Map<String, Object> rawMap) {
        return null;
    }

    @Override
    public String type() {
        return ObjectNameEnum.RL_END.getObjectName();
    }
}
