package com.bxm.localnews.im.thirdpart.rongcloud;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 红包类型处理器
 * http://10.10.1.40:8090/pages/viewpage.action?pageId=7441541
 */
@Component
public class RedPacketProcesser extends AbstractRongCloudProcesser {
	@Override
	public String parseBrief(String source) {
		return "[定时红包]";
	}

	@Override
	public String parse(String source) {
		String content = parseToJson(source).getString("content");
		JSONObject jsonObject = parseToJson(content);
		return jsonObject.getString("name");
	}

	@Override
	public String build(Map<String, Object> rawMap) {
		return null;
	}

	@Override
	public String type() {
		return "LN:RedPacket";
	}

}
