package com.bxm.localnews.im.thirdpart.rongcloud;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 富文本（图文混排）类型处理器
 * https://www.rongcloud.cn/docs/message_architecture.html#richcontent_message
 */
@Component
public class RichTextProcesser extends AbstractRongCloudProcesser {
    @Override
    public String parseBrief(String source) {
        return parseToJson(source).getString("content");
    }

    @Override
    public String parse(String source) {
        JSONObject json = parseToJson(source);
        String content = json.getString("content");
        String imgage = json.getString("imageUri");
        String clickUrl = json.getString("url");
        return content + "|" + imgage + "|" + clickUrl;
    }

    @Override
    public String build(Map<String, Object> rawMap) {
        return null;
    }

    @Override
    public String type() {
        return "RC:ImgTextMsg";
    }
}
