package com.bxm.localnews.im.thirdpart.rongcloud;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 *  帖子分享类型处理器
 */
@Component
public class SharePostProcesser extends AbstractRongCloudProcesser {
	@Override
	public String parseBrief(String source) {
		return "[帖子分享]";
	}

	@Override
	public String parse(String source) {
		JSONObject json = parseToJson(source);
		String content = json.getString("content");
		JSONObject resultJson = parseToJson(content);
		StringBuilder result  = new StringBuilder();
		result.append("id:")
				.append(resultJson.get("id"))
				.append(";标题:")
				.append(resultJson.get("title"));
		return result.toString();
	}

	@Override
	public String build(Map<String, Object> rawMap) {
		return null;
	}

	@Override
	public String type() {
		return "LN:SharePost";
	}
}
