package com.bxm.localnews.im.thirdpart.rongcloud;

import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 纯文字消息
 * https://www.rongcloud.cn/docs/message_architecture.html#text_message
 */
@Component
public class TextProcesser extends AbstractRongCloudProcesser {
    @Override
    public String parseBrief(String source) {
        return parseToJson(source).getString("content");
    }

    @Override
    public String parse(String source) {
        return parseToJson(source).getString("content");
    }

    @Override
    public String build(Map<String, Object> rawMap) {
        return null;
    }

    @Override
    public String type() {
        return "RC:TxtMsg";
    }
}
