package com.bxm.localnews.im.thirdpart.rongcloud;

import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 语音消息
 * https://www.rongcloud.cn/docs/message_architecture.html#voice_message
 */
@Component
public class VoiceProcesser extends AbstractRongCloudProcesser {
    @Override
    public String parseBrief(String source) {
        return "[语音]";
    }

    @Override
    public String parse(String source) {
        //如果需要听语音，需要进行格式转换处理
        //语音内容，格式为 AMR，以 Base64 进行 Encode 后需要将所有 \r\n 和 \r 和 \n 替换成空，大小建议不超过 60k。
        return parseToJson(source).getString("content");
    }

    @Override
    public String build(Map<String, Object> rawMap) {
        return null;
    }

    @Override
    public String type() {
        return "RC:VcMsg";
    }
}
