package com.bxm.localnews.im.user;


import com.bxm.localnews.im.vo.UserBlockBean;
import com.bxm.newidea.component.bo.Message;

import java.util.Date;
import java.util.List;

public interface UserBlockService {
    /**
     * 添加用户屏蔽记录
     *
     * @param userId      用户ID
     * @param blockUserId 被屏蔽用户ID
     * @return 操作结果
     */
    Message add(Long userId, Long blockUserId);

    /**
     * 取消用户消息屏蔽
     *
     * @param userId      用户ID
     * @param blockUserId 取消屏蔽的用户ID
     * @return 操作结果
     */
    Message cancel(Long userId, Long blockUserId);

    /**
     * 封禁用户，封禁后多用户无法给任何用户发送消息
     *
     * @param userId  封禁的用户ID
     * @param minutes 封禁的时长
     * @return 操作结果
     */
    Message block(Long userId, int minutes);

    /**
     * 解除用户封禁，解除后可正常使用即时通讯功能
     *
     * @param userId 用户ID
     * @return 操作结果
     */
    Message unblock(Long userId);

    /**
     * 获取到达过期时间，但是未解除屏蔽状态的用户
     *
     * @param expiredTime 过期时间
     * @return 屏蔽用户列表
     */
    List<UserBlockBean> getExpiredBlockList(Date expiredTime);
}
