package com.bxm.localnews.im.user.impl;

import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.message.utils.AdminUtils;
import com.bxm.localnews.im.domain.UserBlockMapper;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.localnews.im.user.UserBlockService;
import com.bxm.localnews.im.vo.UserBlockBean;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Slf4j
@Service
public class UserBlockServiceImpl implements UserBlockService {

    @Resource
    private UserBlockMapper userBlockMapper;

    @Resource
    private IMSDKAdapter imsdkAdapter;

    @Resource
    private MessageFacadeService messageFacadeService;

    @Resource
    private SequenceCreater sequenceCreate;

    @Override
    public Message add(Long userId, Long blockUserId) {
        Preconditions.checkArgument(userId != null);
        Preconditions.checkArgument(blockUserId != null);

        UserBlockBean entity = UserBlockBean.builder()
                .id(sequenceCreate.nextLongId())
                .blockUserId(blockUserId)
                .userId(userId)
                .status((byte) 1)
                .createTime(new Date())
                .build();

        return Message.build(userBlockMapper.insert(entity));
    }

    @Override
    public Message cancel(Long userId, Long blockUserId) {
        Preconditions.checkArgument(userId != null);
        Preconditions.checkArgument(blockUserId != null);

        return Message.build(userBlockMapper.cancel(userId, blockUserId));
    }

    @Override
    public Message block(Long userId, int minutes) {
        if (null == userId || minutes <= 0) {
            return Message.build(false, "请求参数错误");
        }
        Message message = imsdkAdapter.block(userId, minutes);

        if (message.isSuccess()) {
            log.debug("添加定时解封任务，用户ID：[{}]，封禁时长：[{}]", userId, minutes);

            UserBlockBean entity = UserBlockBean.builder()
                    .id(sequenceCreate.nextLongId())
                    .userId(AdminUtils.getAdminUserId())
                    .blockUserId(userId)
                    .status((byte) 1)
                    .createTime(new Date())
                    .expiredTime(DateUtils.addField(new Date(), Calendar.MINUTE, minutes))
                    .build();
            userBlockMapper.insert(entity);
        }

        return message;
    }

    @Override
    public Message unblock(Long userId) {
        if (null == userId) {
            return Message.build(false, "请求参数错误");
        }
        
        Message message = imsdkAdapter.unblock(userId);
        if (message.isSuccess()) {
            userBlockMapper.unblock(userId);
        }

        return message;
    }

    @Override
    public List<UserBlockBean> getExpiredBlockList(Date expiredTime) {
        return userBlockMapper.getExpiredBlockList(expiredTime);
    }
}
