/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.activity.impl;

import cn.hutool.core.date.DateUtil;
import com.bxm.localnews.im.activity.RedPacketDetailService;
import com.bxm.localnews.im.activity.RedPacketReminderService;
import com.bxm.localnews.im.activity.RedpacketReceiveService;
import com.bxm.localnews.im.config.RedPacketProperties;
import com.bxm.localnews.im.constant.RedPacketRedisConstant;
import com.bxm.localnews.im.domain.activity.RedpacketPlanDetailMapper;
import com.bxm.localnews.im.domain.activity.RedpacketPlanMapper;
import com.bxm.localnews.im.dto.activity.RedPackageDto;
import com.bxm.localnews.im.dto.activity.RedPackageStatusDto;
import com.bxm.localnews.im.entity.activity.RedpacketPlanDetailEntity;
import com.bxm.localnews.im.entity.activity.RedpacketPlanEntity;
import com.bxm.localnews.im.entity.group.ImGroupEntity;
import com.bxm.localnews.im.enums.GroupStatusEnum;
import com.bxm.localnews.im.enums.RedpacketStatusEnum;
import com.bxm.localnews.im.group.GroupService;
import com.bxm.localnews.im.group.GroupTotalService;
import com.bxm.localnews.im.param.activity.RedPackageStatusParam;
import com.bxm.localnews.im.param.group.BaseGroupParam;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.localnews.im.thirdpart.message.RedPacketMessage;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class RedPacketDetailServiceImpl
implements RedPacketDetailService {
    private static final Logger log = LoggerFactory.getLogger(RedPacketDetailServiceImpl.class);
    private RedpacketPlanDetailMapper redpacketPlanDetailMapper;
    private RedpacketPlanMapper redpacketPlanMapper;
    private RedPacketReminderService redPacketReminderService;
    private RedpacketReceiveService redpacketReceiveService;
    private RedPacketProperties redPacketProperties;
    private RedisStringAdapter redisStringAdapter;
    private GroupService groupService;
    private GroupTotalService groupTotalService;
    private IMSDKAdapter imsdkAdapter;

    @Override
    public RedPackageDto getClosestRedpacket(BaseGroupParam param) {
        Date closestTime = DateUtils.addField((Date)new Date(), (int)10, (int)2);
        Date beforeTime = DateUtils.addField((Date)new Date(), (int)10, (int)-1);
        List closestRedpacketList = this.redpacketPlanDetailMapper.getClosestRedpacket(param.getGroupId(), beforeTime, closestTime);
        if (closestRedpacketList.size() == 0) {
            return null;
        }
        RedpacketPlanDetailEntity closestRedpacket = null;
        Optional<RedpacketPlanDetailEntity> firstRedpacket = closestRedpacketList.stream().filter(redpacket -> RedpacketStatusEnum.WAIT.match(redpacket.getStatus()) || RedpacketStatusEnum.RECEIVE.match(redpacket.getStatus())).findFirst();
        if (firstRedpacket.isPresent()) {
            closestRedpacket = firstRedpacket.get();
        } else {
            Optional<RedpacketPlanDetailEntity> firstFinishRedpacket = Lists.reverse((List)closestRedpacketList).stream().filter(redpacket -> RedpacketStatusEnum.FINISH.match(redpacket.getStatus())).findFirst();
            if (firstFinishRedpacket.isPresent()) {
                closestRedpacket = firstFinishRedpacket.get();
            }
        }
        if (null == closestRedpacket) {
            return null;
        }
        String dayStr = "\u4eca\u5929";
        if (!DateUtil.isSameDay((Date)new Date(), (Date)closestRedpacket.getReceiveTime())) {
            dayStr = DateUtils.before((Date)closestRedpacket.getReceiveTime(), (Date)new Date()) ? "\u6628\u5929" : "\u660e\u5929";
        }
        RedPackageDto packageInfo = RedPackageDto.builder().title(this.redPacketProperties.getDefaultRedpacketTitle()).redpacketId(closestRedpacket.getId()).startTime(closestRedpacket.getReceiveTime()).status(closestRedpacket.getStatus()).dayStr(dayStr).enableNotify(Boolean.valueOf(this.redPacketReminderService.enableRemind(param.getUserId(), param.getGroupId()))).build();
        if (RedpacketStatusEnum.RECEIVE.match(closestRedpacket.getStatus())) {
            packageInfo.setContent("\u7cae\u98df\u793c\u5305\u6d3e\u53d1\u4e2d");
        } else if (RedpacketStatusEnum.WAIT.match(closestRedpacket.getStatus())) {
            String receiveTime = ((DateFormat)DateUtils.PATTERN_HOUR_MINUTE_FORMAT.get()).format(closestRedpacket.getReceiveTime());
            packageInfo.setReceiveTimeStr(receiveTime);
            packageInfo.setContent("\u51c6\u65f6\u5f00\u62a2");
        } else {
            String receiveTime = ((DateFormat)DateUtils.PATTERN_HOUR_MINUTE_FORMAT.get()).format(closestRedpacket.getReceiveTime());
            packageInfo.setReceiveTimeStr(receiveTime);
            packageInfo.setContent("\u793c\u5305\u6d3e\u5b8c\u4e86");
        }
        return packageInfo;
    }

    @Override
    public RedPackageStatusDto getUserRedpacketStatus(RedPackageStatusParam param) {
        RedPackageStatusDto status = this.getStatus(param.getRedPackageId());
        if (RedpacketStatusEnum.RECEIVE.match(status.getStatus()) && this.redpacketReceiveService.isReceived(param.getRedPackageId(), param.getUserId())) {
            status.setStatus(Integer.valueOf(RedpacketStatusEnum.CLOSE.getCode()));
        }
        return status;
    }

    @Override
    public RedPackageStatusDto getStatus(Long detailId) {
        return this.loadRedpacketCache(detailId);
    }

    private RedPackageStatusDto loadRedpacketCache(Long detailId) {
        KeyGenerator detailKey = this.buildDetailKey(detailId);
        RedPackageStatusDto statusDto = (RedPackageStatusDto)this.redisStringAdapter.get(detailKey, RedPackageStatusDto.class);
        if (null == statusDto) {
            RedpacketPlanDetailEntity detailEntity = (RedpacketPlanDetailEntity)this.redpacketPlanDetailMapper.selectById((Serializable)detailId);
            if (null == detailEntity) {
                statusDto = RedPackageStatusDto.builder().id(detailId).senderImg(this.redPacketProperties.getDefaultRedpacketHeadImg()).title(this.redPacketProperties.getDefaultRedpacketTitle()).content(RedpacketStatusEnum.CLOSE.getContent()).status(Integer.valueOf(RedpacketStatusEnum.FINISH.getCode())).build();
            } else {
                statusDto = RedPackageStatusDto.builder().senderImg(this.redPacketProperties.getDefaultRedpacketHeadImg()).title(this.redPacketProperties.getDefaultRedpacketTitle()).id(detailId).relationId(detailEntity.getRelationId()).status(detailEntity.getStatus()).receiveTime(detailEntity.getReceiveTime()).build();
                if (RedpacketStatusEnum.WAIT.match(detailEntity.getStatus())) {
                    statusDto.setContent(RedpacketStatusEnum.WAIT.getContent());
                } else if (RedpacketStatusEnum.RECEIVE.match(detailEntity.getStatus())) {
                    statusDto.setContent(RedpacketStatusEnum.RECEIVE.getContent());
                } else {
                    statusDto.setStatus(Integer.valueOf(RedpacketStatusEnum.FINISH.getCode()));
                    statusDto.setContent(RedpacketStatusEnum.FINISH.getContent());
                }
            }
            this.redisStringAdapter.set(detailKey, (Object)statusDto, 7200L);
        }
        return statusDto;
    }

    private KeyGenerator buildDetailKey(Long detailId) {
        return RedPacketRedisConstant.REDPACKET_DETAIL_KEY.copy().appendKey((Object)detailId);
    }

    private void removeRedpacketCache(Long detailId) {
        KeyGenerator detailKey = this.buildDetailKey(detailId);
        this.redisStringAdapter.remove(detailKey);
    }

    @Override
    public void removePlanDetail(Long planId) {
        log.info("\u79fb\u9664\u7ea2\u5305\u6295\u653e\u8ba1\u5212[{}]\u5bf9\u5e94\u7684\u7ea2\u5305", (Object)planId);
        RedpacketPlanDetailEntity activeRedpacket = this.redpacketPlanDetailMapper.getActiveRedpacket(planId);
        if (activeRedpacket != null) {
            this.redPacketReminderService.removeRedpacketRemind(activeRedpacket.getId());
            this.redpacketReceiveService.removeReceiveQueue(activeRedpacket.getId());
            RedpacketPlanDetailEntity updateEntity = new RedpacketPlanDetailEntity();
            updateEntity.setId(activeRedpacket.getId());
            updateEntity.setStatus(Integer.valueOf(RedpacketStatusEnum.CLOSE.getCode()));
            this.redpacketPlanDetailMapper.updateById((Object)updateEntity);
            this.removeRedpacketCache(activeRedpacket.getId());
        }
    }

    @Override
    @Async
    public void closePlanDetail(Long redpacketDetailId) {
        RedpacketPlanDetailEntity detailEntity = (RedpacketPlanDetailEntity)this.redpacketPlanDetailMapper.selectById((Serializable)redpacketDetailId);
        if (detailEntity != null) {
            RedpacketPlanDetailEntity updateEntity = new RedpacketPlanDetailEntity();
            updateEntity.setId(detailEntity.getId());
            updateEntity.setStatus(Integer.valueOf(RedpacketStatusEnum.FINISH.getCode()));
            updateEntity.setFinishTime(new Date());
            this.redpacketPlanDetailMapper.updateById((Object)updateEntity);
            this.redPacketReminderService.removeRedpacketRemind(redpacketDetailId);
            this.redpacketReceiveService.removeReceiveQueue(redpacketDetailId);
            this.removeRedpacketCache(redpacketDetailId);
            this.groupTotalService.addRedpacket(detailEntity.getRelationId(), detailEntity.getTotalGrain());
        }
    }

    @Override
    public void processStatusPlan() {
        List waitRedpacketList = this.redpacketPlanDetailMapper.getWaitRedpacket(new Date());
        for (RedpacketPlanDetailEntity detailEntity : waitRedpacketList) {
            log.info("\u7ea2\u5305[{}]\u66f4\u65b0\u4e3a\u53ef\u9886\u53d6\u72b6\u6001\uff0c\u9884\u8ba1\u65f6\u95f4\uff1a{},\u5b9e\u9645\u65f6\u95f4\uff1a{}", new Object[]{detailEntity.getId(), DateUtils.formatDateTime((Date)detailEntity.getReceiveTime()), DateUtils.formatDateTime((Date)new Date())});
            RedpacketPlanDetailEntity updateEntity = new RedpacketPlanDetailEntity();
            updateEntity.setId(detailEntity.getId());
            updateEntity.setStatus(Integer.valueOf(RedpacketStatusEnum.RECEIVE.getCode()));
            this.redpacketPlanDetailMapper.updateById((Object)updateEntity);
            this.removeRedpacketCache(detailEntity.getId());
            RedPacketMessage redPacketMessage = RedPacketMessage.builder().name("\u5b9a\u65f6\u7cae\u98df\u793c\u5305").redPacketId(String.valueOf(detailEntity.getId())).typeName("\u5b9a\u65f6\u7ea2\u5305").build();
            this.imsdkAdapter.sendGroupMessage(detailEntity.getRelationId(), this.redPacketProperties.getChatRoomTimingRedPacketAssistantUserId(), redPacketMessage);
        }
    }

    @Override
    public void createPlanDetail(Long planId) {
        RedpacketPlanEntity planEntity = (RedpacketPlanEntity)this.redpacketPlanMapper.selectById((Serializable)planId);
        ImGroupEntity groupEntity = this.groupService.getGroupEntity(planEntity.getRelationId());
        if (groupEntity == null || GroupStatusEnum.DISABLE.match(groupEntity.getStatus())) {
            log.info("\u7fa4\u7ec4[{}]\u5df2\u88ab\u7981\u7528\u6216\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5f00\u542f\u65b0\u7684\u7ea2\u5305", (Object)planEntity.getRelationId());
            return;
        }
        if (planEntity.getMaxTimes() > 0 && planEntity.getMaxTimes() <= planEntity.getCurrentTimes()) {
            RedpacketPlanEntity updatePlanEntity = new RedpacketPlanEntity();
            updatePlanEntity.setEnable(Integer.valueOf(0));
            updatePlanEntity.setId(planEntity.getId());
            this.redpacketPlanMapper.updateById((Object)updatePlanEntity);
            log.info("\u7ea2\u5305\u8ba1\u5212[{}]\u5df2\u7ecf\u8fbe\u5230\u6295\u653e\u7684\u6700\u5927\u6b21\u6570", (Object)planId);
            return;
        }
        RedpacketPlanEntity updatePlanEntity = new RedpacketPlanEntity();
        updatePlanEntity.setId(planId);
        updatePlanEntity.setVersion(planEntity.getVersion());
        updatePlanEntity.setCurrentTimes(planEntity.getCurrentTimes());
        if (this.redpacketPlanMapper.addTimes(updatePlanEntity) > 0) {
            RedpacketPlanDetailEntity detailEntity = this.of(planEntity);
            this.redpacketPlanDetailMapper.insert((Object)detailEntity);
            this.redpacketReceiveService.createReceiveQueue(detailEntity);
            this.redPacketReminderService.addRedpacketRemind(detailEntity);
            log.info("\u521b\u5efa\u7ea2\u5305\u6210\u529f\uff0c\u6295\u653e\u8ba1\u5212\uff1a{}", (Object)planId);
        } else {
            log.error("\u521b\u5efa\u7ea2\u5305\u8be6\u60c5\u5931\u8d25\uff0c\u7ea2\u5305\u8ba1\u5212\uff1a{}", (Object)planId);
        }
    }

    private RedpacketPlanDetailEntity of(RedpacketPlanEntity planEntity) {
        Date clearNow = DateUtils.clearTimePart((Date)new Date());
        clearNow = DateUtils.setField((Date)clearNow, (int)10, (int)planEntity.getHour());
        clearNow = DateUtils.setField((Date)clearNow, (int)12, (int)planEntity.getMinute());
        RedpacketPlanDetailEntity entity = new RedpacketPlanDetailEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setStatus(Integer.valueOf(RedpacketStatusEnum.WAIT.getCode()));
        entity.setReceiveTime(clearNow);
        entity.setCreateTime(new Date());
        entity.setTotalGrain(planEntity.getTotalGrain());
        entity.setMinNum(planEntity.getMinNum());
        entity.setMaxNum(planEntity.getMaxNum());
        entity.setPlanId(planEntity.getId());
        entity.setTimes(Integer.valueOf(planEntity.getCurrentTimes() + 1));
        entity.setType(planEntity.getType());
        entity.setRelationId(planEntity.getRelationId());
        if (DateUtils.before((Date)clearNow, (Date)new Date())) {
            entity.setStatus(Integer.valueOf(RedpacketStatusEnum.RECEIVE.getCode()));
        }
        return entity;
    }

    public RedPacketDetailServiceImpl(RedpacketPlanDetailMapper redpacketPlanDetailMapper, RedpacketPlanMapper redpacketPlanMapper, RedPacketReminderService redPacketReminderService, RedpacketReceiveService redpacketReceiveService, RedPacketProperties redPacketProperties, RedisStringAdapter redisStringAdapter, GroupService groupService, GroupTotalService groupTotalService, IMSDKAdapter imsdkAdapter) {
        this.redpacketPlanDetailMapper = redpacketPlanDetailMapper;
        this.redpacketPlanMapper = redpacketPlanMapper;
        this.redPacketReminderService = redPacketReminderService;
        this.redpacketReceiveService = redpacketReceiveService;
        this.redPacketProperties = redPacketProperties;
        this.redisStringAdapter = redisStringAdapter;
        this.groupService = groupService;
        this.groupTotalService = groupTotalService;
        this.imsdkAdapter = imsdkAdapter;
    }
}

