/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.activity.impl;

import com.bxm.egg.message.param.manage.IdParam;
import com.bxm.egg.message.utils.AdminUtils;
import com.bxm.localnews.im.activity.RedPacketDetailService;
import com.bxm.localnews.im.activity.RedPacketPlanService;
import com.bxm.localnews.im.domain.activity.RedpacketPlanMapper;
import com.bxm.localnews.im.dto.activity.ImTimingRedPacketPlanDTO;
import com.bxm.localnews.im.entity.activity.RedpacketPlanEntity;
import com.bxm.localnews.im.enums.RedPacketTypeEnum;
import com.bxm.localnews.im.param.activity.ChangeRedPackageStatusParam;
import com.bxm.localnews.im.param.activity.CreateTimingRedPacketPlanParam;
import com.bxm.localnews.im.param.activity.UpdateTimingRedPacketPlanParam;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedPacketPlanServiceImpl
implements RedPacketPlanService {
    private static final Logger log = LoggerFactory.getLogger(RedPacketPlanServiceImpl.class);
    private RedpacketPlanMapper redpacketPlanMapper;
    private RedPacketDetailService redPacketDetailService;

    @Override
    public List<ImTimingRedPacketPlanDTO> getPlanListByGroupId(Long groupId) {
        List planDTOList = this.redpacketPlanMapper.getPlanListByGroupId(groupId);
        Iterator iterator = planDTOList.iterator();
        while (iterator.hasNext()) {
            ImTimingRedPacketPlanDTO packetPlanDTO;
            packetPlanDTO.setEveryDay(Boolean.valueOf(-1 == (packetPlanDTO = (ImTimingRedPacketPlanDTO)iterator.next()).getMaxTimes()));
        }
        return planDTOList;
    }

    @Override
    public Message createPlan(CreateTimingRedPacketPlanParam param) {
        RedpacketPlanEntity entity = new RedpacketPlanEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setCreateTime(new Date());
        entity.setCurrentTimes(Integer.valueOf(0));
        entity.setEnable(Integer.valueOf(1));
        if (Boolean.TRUE.equals(param.getEveryDay())) {
            entity.setMaxTimes(Integer.valueOf(-1));
        } else {
            entity.setMaxTimes(Integer.valueOf(1));
        }
        entity.setType(Integer.valueOf(RedPacketTypeEnum.GROUP.getType()));
        entity.setHour(param.getSendHour());
        entity.setMinute(param.getSendMinute());
        entity.setMinNum(param.getMinGrainNum());
        entity.setMaxNum(param.getMaxGrainNum());
        entity.setTotalGrain(param.getTotalGrainNum());
        entity.setRelationId(param.getGroupId());
        entity.setOperator(AdminUtils.getAdminUserId());
        Message message = this.check(entity);
        if (!message.isSuccess()) {
            return message;
        }
        int result = this.redpacketPlanMapper.insert((Object)entity);
        return Message.build((int)result);
    }

    @Override
    public Message changePlan(UpdateTimingRedPacketPlanParam param) {
        RedpacketPlanEntity entity = new RedpacketPlanEntity();
        entity.setId(param.getRecordId());
        entity.setHour(param.getSendHour());
        entity.setMinute(param.getSendMinute());
        entity.setTotalGrain(param.getTotalGrainNum());
        entity.setMinNum(param.getMinGrainNum());
        entity.setMaxNum(param.getMaxGrainNum());
        if (Boolean.TRUE.equals(param.getEveryDay())) {
            entity.setMaxTimes(Integer.valueOf(-1));
        } else {
            entity.setMaxTimes(Integer.valueOf(1));
        }
        Message message = this.check(entity);
        if (!message.isSuccess()) {
            return message;
        }
        this.redPacketDetailService.removePlanDetail(entity.getId());
        return Message.build((int)this.redpacketPlanMapper.updateById((Object)entity));
    }

    private Message check(RedpacketPlanEntity entity) {
        if (entity.getMinNum() > entity.getMaxNum()) {
            return Message.build((boolean)false, (String)"\u53ef\u9886\u53d6\u6570\u91cf\u6700\u5c0f\u503c\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u503c");
        }
        return Message.build();
    }

    @Override
    public Message remove(IdParam param) {
        this.redPacketDetailService.removePlanDetail(param.getId());
        return Message.build((int)this.redpacketPlanMapper.remove(param.getId()));
    }

    @Override
    public Message changeStatus(ChangeRedPackageStatusParam param) {
        if (Objects.equals(0, param.getStatus())) {
            this.redPacketDetailService.removePlanDetail(param.getId());
        }
        return Message.build((int)this.redpacketPlanMapper.changeStatus(param));
    }

    @Override
    public void processPlan() {
        LocalDateTime nowTime = LocalDateTime.now(ZoneId.systemDefault());
        LocalDateTime maxTime = LocalDateTime.now(ZoneId.systemDefault());
        maxTime = maxTime.plusHours(2L);
        Date today = DateUtils.clearTimePart((Date)new Date());
        List activePlanList = this.redpacketPlanMapper.queryActivePlanByTime(nowTime.getHour(), maxTime.getHour(), today);
        for (RedpacketPlanEntity planEntity : activePlanList) {
            this.redPacketDetailService.createPlanDetail(planEntity.getId());
        }
    }

    public RedPacketPlanServiceImpl(RedpacketPlanMapper redpacketPlanMapper, RedPacketDetailService redPacketDetailService) {
        this.redpacketPlanMapper = redpacketPlanMapper;
        this.redPacketDetailService = redPacketDetailService;
    }
}

