/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.activity.impl;

import com.bxm.egg.common.url.ProtocolFactory;
import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.egg.mq.common.constant.TemplateTypeEnum;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.mq.common.model.dto.PushPayloadInfo;
import com.bxm.egg.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.im.activity.RedPacketReminderService;
import com.bxm.localnews.im.config.RedPacketProperties;
import com.bxm.localnews.im.constant.RedPacketRedisConstant;
import com.bxm.localnews.im.domain.activity.RedpacketPlanDetailMapper;
import com.bxm.localnews.im.domain.activity.RedpacketRemindMapper;
import com.bxm.localnews.im.domain.activity.RedpacketRemindMessageMapper;
import com.bxm.localnews.im.entity.activity.RedpacketPlanDetailEntity;
import com.bxm.localnews.im.entity.activity.RedpacketRemindEntity;
import com.bxm.localnews.im.entity.activity.RedpacketRemindMessageEntity;
import com.bxm.localnews.im.entity.group.ImGroupEntity;
import com.bxm.localnews.im.enums.GroupStatusEnum;
import com.bxm.localnews.im.group.GroupService;
import com.bxm.localnews.im.param.activity.RedPackageRemindParam;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.localnews.im.thirdpart.message.TextMessage;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedPacketReminderServiceImpl
implements RedPacketReminderService {
    private static final Logger log = LoggerFactory.getLogger(RedPacketReminderServiceImpl.class);
    private RedpacketRemindMapper redpacketRemindMapper;
    private RedpacketRemindMessageMapper redpacketRemindMessageMapper;
    private IMSDKAdapter imsdkAdapter;
    private DistributedLock distributedLock;
    private RedPacketProperties redPacketProperties;
    private RedpacketPlanDetailMapper redpacketPlanDetailMapper;
    private GroupService groupService;
    private MessageFacadeService messageFacadeService;

    @Override
    public Message addOrRemoveRemind(RedPackageRemindParam param) {
        if (param.getSwitchVal().booleanValue()) {
            RedpacketRemindEntity remindEntity = this.redpacketRemindMapper.selectByUserId(param.getUserId(), param.getGroupId());
            if (remindEntity == null) {
                RedpacketRemindEntity saveEntity = new RedpacketRemindEntity();
                saveEntity.setId(SequenceHolder.nextLongId());
                saveEntity.setUserId(param.getUserId());
                saveEntity.setGroupId(param.getGroupId());
                saveEntity.setCreateTime(new Date());
                this.redpacketRemindMapper.insert((Object)saveEntity);
            }
        } else {
            this.redpacketRemindMapper.deleteByUserId(param.getUserId(), param.getGroupId());
        }
        return Message.build();
    }

    @Override
    public boolean enableRemind(Long userId, Long groupId) {
        return this.redpacketRemindMapper.selectByUserId(userId, groupId) != null;
    }

    @Override
    public void processRemind() {
        String lockKey = RedPacketRedisConstant.REDPACKET_REMIND_LOCK.gen();
        if (this.distributedLock.lock(lockKey)) {
            Date sendTime = DateUtils.addField((Date)new Date(), (int)12, (int)1);
            List unsentRemindList = this.redpacketRemindMessageMapper.queryRemind(sendTime);
            if (unsentRemindList.size() > 0) {
                for (RedpacketRemindMessageEntity remindMessageEntity : unsentRemindList) {
                    this.imsdkAdapter.sendGroupMessage(remindMessageEntity.getRelationId(), this.redPacketProperties.getChatRoomTimingRedPacketAssistantUserId(), TextMessage.builder().content(remindMessageEntity.getContent()).build());
                }
                this.redpacketRemindMessageMapper.removeSendRemind(sendTime);
            }
            this.distributedLock.unlock(lockKey);
        } else {
            log.info("\u5176\u4ed6\u5b9e\u4f8b\u5df2\u7ecf\u5904\u7406\u4e86\u7ea2\u5305\u7684\u7cfb\u7edf\u6d88\u606f\u63d0\u9192");
        }
    }

    @Override
    public void processUserRemind() {
        String lockKey = RedPacketRedisConstant.REDPACKET_USER_REMIND_LOCK.gen();
        if (this.distributedLock.lock(lockKey, 1L, TimeUnit.MINUTES)) {
            Date receiveDate = DateUtils.addField((Date)new Date(), (int)12, (int)5);
            List waitRedpacketList = this.redpacketPlanDetailMapper.getWaitRedpacket(receiveDate);
            if (waitRedpacketList.size() > 0) {
                for (RedpacketPlanDetailEntity detailEntity : waitRedpacketList) {
                    ImGroupEntity groupEntity = this.groupService.getGroupEntity(detailEntity.getRelationId());
                    if (GroupStatusEnum.DISABLE.match(groupEntity.getStatus())) {
                        log.info("\u7fa4\u7ec4[{}]\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u9700\u8981\u53d1\u9001\u63d0\u9192\u4fe1\u606f", (Object)detailEntity.getRelationId());
                        continue;
                    }
                    this.sendAllRemind(detailEntity);
                }
            }
        } else {
            log.info("\u5176\u4ed6\u5b9e\u4f8b\u6b63\u5728\u6267\u884c\u7528\u6237\u7ea2\u5305\u63d0\u9192");
        }
    }

    private void sendAllRemind(RedpacketPlanDetailEntity detailEntity) {
        List userIdList = this.redpacketRemindMapper.selectRemindUserByGroupId(detailEntity.getRelationId());
        String protocol = ProtocolFactory.groupChat().app().groupId(detailEntity.getRelationId()).build();
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.IM_CHAT_ROOM_TIMING_RED_PACKET_MESSAGE);
        info.setMsgId(SequenceHolder.nextLongId());
        info.addExtend("url", (Object)protocol);
        info.addExtend("chatRoomId", (Object)detailEntity.getRelationId());
        info.setProtocol(protocol);
        String content = detailEntity.getTotalGrain() + "g\u7cae\u98df\u793c\u5305\u8fd8\u67093\u5206\u949f\u5c31\u8981\u5f00\u62a2\u4e86\uff0c\u8d76\u5feb\u8fdb\u7fa4\u51c6\u5907\u5427~";
        PushMessage message = PushMessage.build();
        message.setTitle("\u7cae\u98df\u793c\u5305\u9a6c\u4e0a\u5f00\u62a2");
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushGroup((List)userIdList));
        message.setPayloadInfo(info);
        this.messageFacadeService.sendPushMessage(message);
    }

    @Override
    public void addRedpacketRemind(RedpacketPlanDetailEntity detail) {
        RedpacketRemindMessageEntity entity = new RedpacketRemindMessageEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setDetailId(detail.getId());
        entity.setSendFlag(Integer.valueOf(0));
        entity.setRelationId(detail.getRelationId());
        entity.setSendTime(DateUtils.addField((Date)detail.getReceiveTime(), (int)13, (int)-120));
        entity.setContent("\u5b9a\u65f6\u7ea2\u5305\u8fd8\u6709120\u79d2\u5230\u8fbe\uff0c\u51c6\u5907\u597d\u5f00\u62a2\u4e86\u5417");
        this.redpacketRemindMessageMapper.insert((Object)entity);
        entity = new RedpacketRemindMessageEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setDetailId(detail.getId());
        entity.setSendFlag(Integer.valueOf(0));
        entity.setRelationId(detail.getRelationId());
        entity.setSendTime(DateUtils.addField((Date)detail.getReceiveTime(), (int)13, (int)-60));
        entity.setContent("\u5b9a\u65f6\u7ea2\u5305\u8fd8\u670960\u79d2\u5230\u8fbe\uff0c\u51c6\u5907\u597d\u5f00\u62a2\u4e86\u5417");
        this.redpacketRemindMessageMapper.insert((Object)entity);
    }

    @Override
    public void removeRedpacketRemind(Long detailId) {
        this.redpacketRemindMessageMapper.deleteByDetailId(detailId);
    }

    public RedPacketReminderServiceImpl(RedpacketRemindMapper redpacketRemindMapper, RedpacketRemindMessageMapper redpacketRemindMessageMapper, IMSDKAdapter imsdkAdapter, DistributedLock distributedLock, RedPacketProperties redPacketProperties, RedpacketPlanDetailMapper redpacketPlanDetailMapper, GroupService groupService, MessageFacadeService messageFacadeService) {
        this.redpacketRemindMapper = redpacketRemindMapper;
        this.redpacketRemindMessageMapper = redpacketRemindMessageMapper;
        this.imsdkAdapter = imsdkAdapter;
        this.distributedLock = distributedLock;
        this.redPacketProperties = redPacketProperties;
        this.redpacketPlanDetailMapper = redpacketPlanDetailMapper;
        this.groupService = groupService;
        this.messageFacadeService = messageFacadeService;
    }
}

