/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.activity.impl;

import com.bxm.egg.message.integration.UserAccountIntegrationService;
import com.bxm.egg.message.integration.UserIntegrationService;
import com.bxm.egg.message.vo.UserInfoBean;
import com.bxm.localnews.im.activity.RedPacketDetailService;
import com.bxm.localnews.im.activity.RedpacketReceiveService;
import com.bxm.localnews.im.activity.strategy.RedpacketQueueContext;
import com.bxm.localnews.im.config.RedPacketProperties;
import com.bxm.localnews.im.constant.RedPacketRedisConstant;
import com.bxm.localnews.im.domain.activity.RedpacketReceiveRecordMapper;
import com.bxm.localnews.im.dto.activity.RedPackageDetailDto;
import com.bxm.localnews.im.dto.activity.RedPackageStatusDto;
import com.bxm.localnews.im.dto.activity.RedPacketReceiveDTO;
import com.bxm.localnews.im.entity.activity.RedpacketPlanDetailEntity;
import com.bxm.localnews.im.entity.activity.RedpacketReceiveRecordEntity;
import com.bxm.localnews.im.enums.RedpacketQueueStrategyEnum;
import com.bxm.localnews.im.enums.RedpacketStatusEnum;
import com.bxm.localnews.im.param.activity.OpenRedPackageParam;
import com.bxm.localnews.im.param.activity.RedPackageDetailParam;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.strategy.ReturnedStrategyExecutor;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedpacketReceiveServiceImpl
implements RedpacketReceiveService {
    private static final Logger log = LoggerFactory.getLogger(RedpacketReceiveServiceImpl.class);
    private RedpacketReceiveRecordMapper redpacketReceiveRecordMapper;
    private RedPacketProperties redPacketProperties;
    private RedisSetAdapter redisSetAdapter;
    private RedisListAdapter redisListAdapter;
    private RedisStringAdapter redisStringAdapter;
    private DistributedLock distributedLock;
    private ReturnedStrategyExecutor returnedStrategyExecutor;
    private UserAccountIntegrationService userAccountIntegrationService;
    private UserIntegrationService userIntegrationService;

    @Override
    public RedPackageDetailDto executeOpen(OpenRedPackageParam param) {
        RedPackageDetailDto detailDto = RedPackageDetailDto.builder().build();
        KeyGenerator lockKey = RedPacketRedisConstant.REDPACKET_OPEN_LOCK.copy().appendKey((Object)param.getRedPackageId()).appendKey((Object)param.getUserId());
        if (this.distributedLock.lock(lockKey.gen())) {
            RedPackageStatusDto status = this.getRedPacketService().getStatus(param.getRedPackageId());
            if (!RedpacketStatusEnum.RECEIVE.match(status.getStatus())) {
                log.warn("\u7ea2\u5305[{}]\u5904\u4e8e\u4e0d\u53ef\u9886\u53d6\u7684\u72b6\u6001\uff0c\u89e6\u53d1\u4e86\u5f00\u542f\u7ea2\u5305", (Object)param.getRedPackageId());
                return detailDto;
            }
            RedPackageDetailParam detailParam = new RedPackageDetailParam();
            detailParam.setRedPackageId(param.getRedPackageId());
            detailParam.setUserId(param.getUserId());
            if (this.isReceived(param.getRedPackageId(), param.getUserId())) {
                detailDto = this.getDetail(detailParam);
                detailDto.setPromptText("\u4f60\u5df2\u7ecf\u9886\u53d6\u8fc7\u8be5\u7ea2\u5305\uff0c\u4e0d\u80fd\u91cd\u590d\u9886\u53d6\u54e6");
            } else {
                KeyGenerator queueKey = this.buildQueueKey(param.getRedPackageId());
                Integer randomItem = (Integer)this.redisListAdapter.leftPop(queueKey, Integer.class);
                if (randomItem == null) {
                    detailDto = this.getDetail(detailParam);
                    detailDto.setPromptText("\u6765\u665a\u4e86\uff0c\u7cae\u98df\u5df2\u7ecf\u88ab\u9886\u5b8c\u4e86");
                } else {
                    this.addRecord(param, randomItem);
                    detailDto = this.getDetail(detailParam);
                    detailDto.setPromptText("\u7cae\u98df\u5df2\u5b58\u5165\u60a8\u7684\u8d26\u6237");
                    this.afterReceiveOver(param.getRedPackageId());
                }
            }
            this.distributedLock.unlock(lockKey.gen());
        }
        return detailDto;
    }

    @Override
    public boolean isReceived(Long detailId, Long userId) {
        KeyGenerator receiveKey = this.buildReceiveUserKey(detailId);
        return this.redisSetAdapter.exists(receiveKey, (Object)userId);
    }

    private void afterReceiveOver(Long detailId) {
        KeyGenerator queueNumKey = this.buildQueueNumKey(detailId);
        Long lastNum = this.redisStringAdapter.decrement(queueNumKey);
        if (lastNum <= 0L) {
            this.getRedPacketService().closePlanDetail(detailId);
        }
    }

    private RedPacketDetailService getRedPacketService() {
        return (RedPacketDetailService)SpringContextHolder.getBean(RedPacketDetailService.class);
    }

    private void addRecord(OpenRedPackageParam param, Integer receiveNum) {
        RedpacketReceiveRecordEntity entity = new RedpacketReceiveRecordEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setCreateTime(new Date());
        entity.setDetailId(param.getRedPackageId());
        entity.setNum(receiveNum);
        entity.setUserId(param.getUserId());
        this.redpacketReceiveRecordMapper.insert((Object)entity);
        Message message = this.userAccountIntegrationService.addRedpacketGrain(param.getUserId(), receiveNum);
        if (!message.isSuccess()) {
            log.error("\u7528\u6237[{}]\u9886\u53d6\u7fa4\u7ea2\u5305\u540e\uff0c\u53d1\u653e\u7cae\u98df[{}]\u5931\u8d25", (Object)param.getUserId(), (Object)receiveNum);
        }
        KeyGenerator receiveKey = this.buildReceiveUserKey(param.getRedPackageId());
        this.redisSetAdapter.add(receiveKey, new Object[]{param.getUserId()});
    }

    private KeyGenerator buildReceiveUserKey(Long detailId) {
        return RedPacketRedisConstant.REDPACKET_RECEIVE_CACHE_KEY.copy().appendKey((Object)detailId);
    }

    private KeyGenerator buildQueueKey(Long detailId) {
        return RedPacketRedisConstant.REDPACKET_RECEIVE_QUEUE_KEY.copy().appendKey((Object)detailId);
    }

    private KeyGenerator buildQueueNumKey(Long detailId) {
        return RedPacketRedisConstant.REDPACKET_RECEIVE_QUEUE_NUM_KEY.copy().appendKey((Object)detailId);
    }

    @Override
    public RedPackageDetailDto getDetail(RedPackageDetailParam param) {
        List allReceiveList = this.redpacketReceiveRecordMapper.getAll(param.getRedPackageId());
        Optional<RedpacketReceiveRecordEntity> currentUser = allReceiveList.stream().filter(receive -> Objects.equals(receive.getUserId(), param.getUserId())).findFirst();
        Integer currentUserReceiveNum = null;
        if (currentUser.isPresent()) {
            currentUserReceiveNum = currentUser.get().getNum();
        }
        List packetReceives = allReceiveList.stream().filter(receive -> !Objects.equals(receive.getUserId(), param.getUserId())).map(this::of).collect(Collectors.toList());
        currentUser.ifPresent(recordEntity -> packetReceives.add(0, this.of((RedpacketReceiveRecordEntity)recordEntity)));
        return RedPackageDetailDto.builder().title(this.redPacketProperties.getDefaultRedpacketTitle()).senderImg(this.redPacketProperties.getDefaultRedpacketHeadImg()).receiveNum(currentUserReceiveNum).otherReceiveList(packetReceives).build();
    }

    private RedPacketReceiveDTO of(RedpacketReceiveRecordEntity recordEntity) {
        UserInfoBean userInfo = this.userIntegrationService.getUserInfo(recordEntity.getUserId());
        RedPacketReceiveDTO receiveDTO = new RedPacketReceiveDTO();
        receiveDTO.setNum(recordEntity.getNum());
        if (recordEntity.getCreateTime() != null) {
            receiveDTO.setReceiveTime(((DateFormat)DateUtils.PATTERN_HOUR_MINUTE_SECEND_FORMAT.get()).format(recordEntity.getCreateTime()));
        }
        receiveDTO.setUserId(recordEntity.getUserId());
        receiveDTO.setHeadImg(userInfo.getHeadImg());
        receiveDTO.setNickName(userInfo.getNickname());
        return receiveDTO;
    }

    @Override
    public void createReceiveQueue(RedpacketPlanDetailEntity detailEntity) {
        RedpacketQueueContext context = RedpacketQueueContext.builder().strategy(RedpacketQueueStrategyEnum.RANDOM).detailEntity(detailEntity).build();
        KeyGenerator queueKey = this.buildQueueKey(detailEntity.getId());
        List queueList = (List)this.returnedStrategyExecutor.execute("RAD_PACKET_QUEUE", (Object)context);
        Object[] queueArray = queueList.toArray(new Integer[0]);
        this.redisListAdapter.rightPush(queueKey, queueArray);
        KeyGenerator queueNumKey = this.buildQueueNumKey(detailEntity.getId());
        this.redisStringAdapter.set(queueNumKey, (long)queueList.size());
    }

    @Override
    public void removeReceiveQueue(Long detailId) {
        KeyGenerator queueKey = this.buildQueueKey(detailId);
        this.redisListAdapter.remove(queueKey);
        KeyGenerator queueNumKey = this.buildQueueNumKey(detailId);
        this.redisStringAdapter.remove(queueNumKey);
        KeyGenerator receiveKey = this.buildReceiveUserKey(detailId);
        this.redisSetAdapter.remove(receiveKey);
    }

    public RedpacketReceiveServiceImpl(RedpacketReceiveRecordMapper redpacketReceiveRecordMapper, RedPacketProperties redPacketProperties, RedisSetAdapter redisSetAdapter, RedisListAdapter redisListAdapter, RedisStringAdapter redisStringAdapter, DistributedLock distributedLock, ReturnedStrategyExecutor returnedStrategyExecutor, UserAccountIntegrationService userAccountIntegrationService, UserIntegrationService userIntegrationService) {
        this.redpacketReceiveRecordMapper = redpacketReceiveRecordMapper;
        this.redPacketProperties = redPacketProperties;
        this.redisSetAdapter = redisSetAdapter;
        this.redisListAdapter = redisListAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.distributedLock = distributedLock;
        this.returnedStrategyExecutor = returnedStrategyExecutor;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.userIntegrationService = userIntegrationService;
    }
}

