/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.activity.strategy;

import com.bxm.localnews.im.activity.strategy.RedpacketQueueContext;
import com.bxm.localnews.im.entity.activity.RedpacketPlanDetailEntity;
import com.bxm.localnews.im.enums.RedpacketQueueStrategyEnum;
import com.bxm.newidea.component.annotations.StrategyBean;
import com.bxm.newidea.component.strategy.IReturnedStrategy;
import com.bxm.newidea.component.tools.RandomUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StrategyBean(group="RAD_PACKET_QUEUE")
public class RandomStrategy
implements IReturnedStrategy<List<Integer>, RedpacketQueueContext> {
    private static final Logger log = LoggerFactory.getLogger(RandomStrategy.class);

    public List<Integer> execute(RedpacketQueueContext redpacketQueueContext) {
        RedpacketPlanDetailEntity detailEntity = redpacketQueueContext.getDetailEntity();
        return this.createRandomQueue(detailEntity.getTotalGrain(), detailEntity.getMinNum(), detailEntity.getMaxNum());
    }

    public boolean match(RedpacketQueueContext param) {
        return RedpacketQueueStrategyEnum.RANDOM.equals((Object)param.getStrategy());
    }

    private List<Integer> createRandomQueue(int total, int min, int max) {
        int mid = (min + max) / 2;
        int num = total / mid;
        if (num == 1) {
            log.warn("\u603b\u6570\u53ea\u591f\u521b\u5efa\u4e00\u4e2a\u968f\u673a\u503c\uff0c\u8fd4\u56de\u603b\u6570\u3002\u603b\u6570\u4e3a\uff1a{},\u6700\u5927\u503c\uff1a{},\u6700\u5c0f\u503c\uff1a{}", new Object[]{total, min, max});
            return Lists.newArrayList((Object[])new Integer[]{total});
        }
        ArrayList result = Lists.newArrayList();
        int last = total;
        for (int i = 0; i < num / 2; ++i) {
            int scope = max - mid;
            if (max - mid > min) {
                scope = (max - mid) / 3;
            }
            int random = RandomUtils.nextInt((int)0, (int)scope);
            result.add(mid + random);
            result.add(mid - random);
            last -= mid * 2;
        }
        if (last != 0) {
            int lastNum = last / mid;
            if (lastNum > 0) {
                for (int i = 0; i < lastNum; ++i) {
                    result.add(mid);
                    last -= mid;
                }
            }
            int fillNum = result.stream().mapToInt(item -> max - item).sum();
            int extractNum = result.stream().mapToInt(item -> item - min).sum();
            if (last <= fillNum) {
                while (last > 0) {
                    for (int i = 0; i < result.size(); ++i) {
                        if (last <= 0 || (Integer)result.get(i) >= max) continue;
                        result.set(i, (Integer)result.get(i) + 1);
                        --last;
                    }
                }
            } else if (extractNum + last >= min) {
                int finalItem = last;
                block4: while (last > 0) {
                    for (int i = 0; i < result.size(); ++i) {
                        if (finalItem >= min) {
                            last = 0;
                            continue block4;
                        }
                        if (last <= 0 || (Integer)result.get(i) >= max || (Integer)result.get(i) <= min) continue;
                        result.set(i, (Integer)result.get(i) - 1);
                        --last;
                        ++finalItem;
                    }
                }
                result.add(finalItem);
            } else {
                log.warn("\u51fa\u73b0\u65e0\u6cd5\u6ee1\u8db3\u9650\u5b9a\u6761\u4ef6\u7684\u60c5\u51b5\uff0c\u603b\u6570\uff1a{}\uff0c\u6700\u5c0f\u503c:{}\uff0c\u6700\u5927\u503c\uff1a{},\u5269\u4f59\u503c\uff1a{}", new Object[]{total, min, max, last});
                result.add(last);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("total:{},min:{},max:{},result:{}", new Object[]{total, min, max, result});
        }
        return result;
    }
}

