/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.chat.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.im.chat.ConsumeService;
import com.bxm.localnews.im.constant.ImRedisKey;
import com.bxm.localnews.im.domain.ChatMessageMapper;
import com.bxm.localnews.im.enums.ChannelTypeEnum;
import com.bxm.localnews.im.param.RongCloudParam;
import com.bxm.localnews.im.thirdpart.MsgContentProcesser;
import com.bxm.localnews.im.thirdpart.RCProcessorFactory;
import com.bxm.localnews.im.thirdpart.enums.MsgTypeEnum;
import com.bxm.localnews.im.vo.IMMessageBean;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Service;

@Service
public class ConsumeServiceImpl
implements ConsumeService,
ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(ConsumeServiceImpl.class);
    private final RedisSetAdapter redisSetAdapter;
    private static final long FETCH_NUM = 500L;

    @Autowired
    public ConsumeServiceImpl(RedisSetAdapter redisSetAdapter) {
        this.redisSetAdapter = redisSetAdapter;
    }

    @Override
    public void write(RongCloudParam param) {
        if (log.isDebugEnabled()) {
            log.debug("\u65b0\u589e\u4e00\u6761\u901a\u8baf\u6d88\u606f\uff1a[{}]", (Object)param);
        }
        this.redisSetAdapter.add(ImRedisKey.MSG_SET, new Object[]{param});
    }

    private void consume() {
        List msgList = this.redisSetAdapter.pop(ImRedisKey.MSG_SET, Long.valueOf(500L), RongCloudParam.class);
        if (msgList.size() > 0) {
            List<IMMessageBean> messages = this.convert(msgList);
            this.batchInsertPersonMessage(messages);
            this.batchInsertGroupMessage(messages);
            if (log.isDebugEnabled()) {
                log.debug("\u6d88\u606f\u5904\u7406\u5b8c\u6210\uff0c\u6d88\u606f\u6570\u91cf\uff1a[{}]", (Object)msgList.size());
            }
            if ((long)msgList.size() >= 500L) {
                this.consume();
            }
        }
    }

    private void batchInsertGroupMessage(List<IMMessageBean> messages) {
        List chatRoomList = messages.stream().filter(e -> StringUtils.equals((CharSequence)ChannelTypeEnum.GROUP.getTypeName(), (CharSequence)e.getChannelType())).collect(Collectors.toList());
        MybatisBatchBuilder.create(ChatMessageMapper.class, chatRoomList).run(ChatMessageMapper::insertGroupMessage);
    }

    private void batchInsertPersonMessage(List<IMMessageBean> messages) {
        List personList = messages.stream().filter(e -> StringUtils.equals((CharSequence)ChannelTypeEnum.PERSON.getTypeName(), (CharSequence)e.getChannelType())).collect(Collectors.toList());
        MybatisBatchBuilder.create(ChatMessageMapper.class, personList).run(ChatMessageMapper::insert);
    }

    private List<IMMessageBean> convert(List<RongCloudParam> msgList) {
        ArrayList messages = Lists.newArrayList();
        for (RongCloudParam paramMsg : msgList) {
            MsgContentProcesser processor = RCProcessorFactory.get(paramMsg.getObjectName());
            IMMessageBean message = this.build(paramMsg, processor);
            processor.callback(message);
            if (!MsgTypeEnum.CONTENT.equals((Object)processor.msgType())) continue;
            messages.add(message);
        }
        return messages;
    }

    private IMMessageBean build(RongCloudParam paramMsg, MsgContentProcesser processor) {
        String briefContent = processor.parseBrief(paramMsg.getContent());
        String parseContent = processor.parse(paramMsg.getContent());
        return IMMessageBean.builder().msgId(paramMsg.getMsgUID()).fromUserId(Long.valueOf(paramMsg.getFromUserId())).toUserId(Long.valueOf(paramMsg.getToUserId())).content(paramMsg.getContent()).briefContent(briefContent).parseContent(parseContent).msgTimestamp(new Date(Long.valueOf(paramMsg.getMsgTimestamp()))).channelType(paramMsg.getChannelType()).groupUserIds(StringUtils.join((Object[])paramMsg.getGroupUserIds(), (String)",")).sensitiveType(paramMsg.getSensitiveType()).source(paramMsg.getSource()).msgType(paramMsg.getObjectName()).build();
    }

    public void run(ApplicationArguments args) {
        ScheduledThreadPoolExecutor threadPool = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("consume-message"));
        threadPool.scheduleAtFixedRate(this::consume, 3L, 3L, TimeUnit.SECONDS);
    }
}

