/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.chat.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.message.dto.LocationDTO;
import com.bxm.egg.message.integration.LocationIntegrationService;
import com.bxm.egg.message.integration.UserIntegrationService;
import com.bxm.egg.message.vo.UserInfoBean;
import com.bxm.localnews.im.chat.IMManageService;
import com.bxm.localnews.im.constant.ImRedisKey;
import com.bxm.localnews.im.domain.IMMapper;
import com.bxm.localnews.im.dto.chat.ChatMessageDTO;
import com.bxm.localnews.im.dto.group.GroupMessageDTO;
import com.bxm.localnews.im.entity.HistoryChatBean;
import com.bxm.localnews.im.param.chat.GroupMessageQueryParam;
import com.bxm.localnews.im.param.chat.ImHistoryParam;
import com.bxm.localnews.im.param.chat.ImMessageQueryParam;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IMManageServiceImpl
implements IMManageService {
    private static final Logger log = LoggerFactory.getLogger(IMManageServiceImpl.class);
    private final IMMapper imMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserIntegrationService userIntegrationService;
    private final LocationIntegrationService locationIntegrationService;

    @Override
    public List<ChatMessageDTO> query(ImMessageQueryParam param) {
        Preconditions.checkArgument((param != null ? 1 : 0) != 0);
        List<Object> result = Lists.newArrayList();
        if (null != param.getSender() && null != param.getReceiver()) {
            result.addAll(this.imMapper.query(param));
            long sender = param.getSender();
            param.setSender(param.getReceiver());
            param.setReceiver(Long.valueOf(sender));
            result.addAll(this.imMapper.query(param));
            result = result.stream().sorted(Comparator.comparing(ChatMessageDTO::getSendTime)).collect(Collectors.toList());
        } else {
            result = this.imMapper.query(param);
        }
        HashSet userIdSet = Sets.newHashSet();
        for (ChatMessageDTO messageBean : result) {
            userIdSet.add(messageBean.getSender());
            userIdSet.add(messageBean.getReceiver());
        }
        Map userInfoBeanMap = this.userIntegrationService.queryUserList((Collection)userIdSet);
        for (ChatMessageDTO messageBean : result) {
            UserInfoBean userInfoBean = (UserInfoBean)userInfoBeanMap.get(messageBean.getReceiver());
            if (null != userInfoBean) {
                messageBean.setReceiverName(userInfoBean.getNickname());
            }
            if (null == (userInfoBean = (UserInfoBean)userInfoBeanMap.get(messageBean.getSender()))) continue;
            messageBean.setSenderName(userInfoBean.getNickname());
        }
        if (!CollectionUtils.isEmpty(result)) {
            result.forEach(e -> {
                if (StringUtils.equals((CharSequence)"RC:VcMsg", (CharSequence)e.getObjectName())) {
                    e.setDuration(Integer.valueOf(this.getDurationByContent(e.getPrimitiveContent())));
                }
            });
        }
        return result;
    }

    @Override
    public IPageModel<GroupMessageDTO> queryGroupMessage(GroupMessageQueryParam param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        PlusPageModelDTO pageModel = PlusPageModelDTO.build((IPage)this.imMapper.queryGroupMessage(page, param));
        for (GroupMessageDTO chatMessageDTO : pageModel.getList()) {
            UserInfoBean userInfo = this.userIntegrationService.getUserInfo(chatMessageDTO.getSender());
            if (null != userInfo) {
                chatMessageDTO.setSenderName(userInfo.getNickname());
            }
            LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(chatMessageDTO.getAreaCode());
            chatMessageDTO.setAreaName(locationDTO.getName());
        }
        return pageModel;
    }

    private int getDurationByContent(String content) {
        JSONObject result = JSONObject.parseObject((String)content);
        return result.getInteger("duration");
    }

    @Override
    public List<HistoryChatBean> queryHistory(ImHistoryParam param) {
        List userIdList = this.imMapper.queryHistory(param);
        Map userInfoBeanMap = this.userIntegrationService.queryUserList((Collection)userIdList);
        ArrayList result = Lists.newArrayList();
        for (Long userId : userIdList) {
            UserInfoBean userInfo = (UserInfoBean)userInfoBeanMap.get(userId);
            if (null == userInfo) continue;
            result.add(this.convert(userInfo));
        }
        return result;
    }

    private HistoryChatBean convert(UserInfoBean userInfo) {
        HistoryChatBean history = new HistoryChatBean();
        history.setUserId(userInfo.getId());
        history.setHeadImg(userInfo.getHeadImg());
        history.setNickName(userInfo.getNickname());
        return history;
    }

    @Override
    public void getVoiceByContent(String id, HttpServletResponse response) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("multipart/form-data");
        response.setHeader("Content-Disposition", "attachment;fileName=" + id + ".amr");
        String content = this.imMapper.selectContentById(id);
        try (ServletOutputStream out = response.getOutputStream();){
            byte[] audioByte = Base64.decode(content);
            out.write(audioByte);
            out.flush();
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u9519\u8bef", (Throwable)e);
        }
    }

    @Override
    public Boolean clearChatRecord(Long virtualUserId, Long realUserId) {
        KeyGenerator unReplyNumKey = ImRedisKey.VIRTURE_USER_UNREPLY.copy().appendKey((Object)virtualUserId);
        Long remove = this.redisHashMapAdapter.remove(unReplyNumKey, new String[]{String.valueOf(realUserId)});
        return remove > 0L;
    }

    public IMManageServiceImpl(IMMapper imMapper, RedisHashMapAdapter redisHashMapAdapter, UserIntegrationService userIntegrationService, LocationIntegrationService locationIntegrationService) {
        this.imMapper = imMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userIntegrationService = userIntegrationService;
        this.locationIntegrationService = locationIntegrationService;
    }
}

