/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.chat.impl;

import com.bxm.egg.common.url.ProtocolFactory;
import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.message.integration.UserAccountIntegrationService;
import com.bxm.egg.message.integration.UserIntegrationService;
import com.bxm.egg.message.vo.UserInfoBean;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.mq.common.param.DingtalkMessage;
import com.bxm.localnews.im.chat.IMService;
import com.bxm.localnews.im.config.IMProperties;
import com.bxm.localnews.im.constant.ImRedisKey;
import com.bxm.localnews.im.domain.ChatMessageMapper;
import com.bxm.localnews.im.integration.ConfigClientIntegrationService;
import com.bxm.localnews.im.param.chat.GiftParam;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.base.Preconditions;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IMServiceImpl
implements IMService {
    private static final Logger log = LoggerFactory.getLogger(IMServiceImpl.class);
    private final IMSDKAdapter imsdkAdapter;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final RedisSetAdapter redisSetAdapter;
    private final UserIntegrationService userIntegrationService;
    private final UserAccountIntegrationService userAccountIntegrationService;
    private final ChatMessageMapper chatMessageMapper;
    private final ConfigClientIntegrationService clientIntegrationService;
    private final MessageFacadeService messageFacadeService;
    private final IMProperties imProperties;

    private KeyGenerator buildKey(Long userId) {
        return ImRedisKey.TOKEN.copy().appendKey((Object)(userId % 10L));
    }

    @Override
    public String getToken(Long userId) {
        log.debug("\u83b7\u53d6token\u5f00\u59cb\uff0c\u7528\u6237:[{}]", (Object)userId);
        Preconditions.checkArgument((null != userId ? 1 : 0) != 0);
        KeyGenerator key = this.buildKey(userId);
        String token = (String)this.redisHashMapAdapter.get(key, userId.toString(), String.class);
        if (null == token) {
            UserInfoBean user = this.userIntegrationService.getUserInfo(userId);
            if (null == user || StringUtils.isEmpty((String)user.getNickname()) || StringUtils.isEmpty((String)user.getHeadImg())) {
                return "";
            }
            token = this.imsdkAdapter.token(user);
            if (StringUtils.isNotBlank((String)token)) {
                this.redisHashMapAdapter.put(key, userId.toString(), (Object)token);
            }
        }
        log.debug("\u83b7\u53d6\u7528\u6237:[{}],token:[{}]", (Object)userId, (Object)token);
        return token;
    }

    @Override
    public void updateUser(Long userId) {
        this.imsdkAdapter.update(this.userIntegrationService.getUserInfo(userId));
    }

    @Override
    public Message executeGift(GiftParam param) {
        KeyGenerator giftKey = ImRedisKey.GIFT_RECORD_KEY.copy().appendKey((Object)param.getUserId()).appendKey((Object)((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
        if (this.redisSetAdapter.exists(giftKey, (Object)param.getTargetUserId()).booleanValue()) {
            return Message.build((boolean)false, (String)"\u4eca\u5929\u5df2\u7ed9\u597d\u53cb\u8d60\u9001\u8fc7\u4e86~\u660e\u5929\u518d\u9001\u5427");
        }
        Message message = this.userAccountIntegrationService.reduce(param.getUserId(), this.imProperties.getReduceGiftGrain());
        if (message.isSuccess()) {
            message = this.userAccountIntegrationService.addGiftGrain(param.getTargetUserId(), this.imProperties.getReduceGiftGrain());
            if (message.isSuccess()) {
                this.redisSetAdapter.add(giftKey, new Object[]{param.getTargetUserId()});
                this.redisSetAdapter.expireWithDisrupt(giftKey, (long)DateUtils.getCurSeconds());
                UserInfoBean userInfo = this.userIntegrationService.getUserInfo(param.getUserId());
                String pushContent = userInfo.getNickname() + "\u7ed9\u4f60\u9001\u6765\u4e86" + this.imProperties.getReduceGiftGrain() + "g\u7cae\u98df\uff0c\u8d76\u5feb\u53bb\u7b54\u8c22\u5427~";
                PushMessage pushMessage = PushMessage.build((String)"\u597d\u53cb\u7ed9\u4f60\u8d60\u7cae\u4e86", (String)pushContent).assign(param.getTargetUserId());
                String toFarmUrl = this.clientIntegrationService.getConfigClientFacadeService().getSpecificConfig("toFarmUrl");
                String protocol = ProtocolFactory.appH5().url(toFarmUrl).build();
                pushMessage.getPayloadInfo().setProtocol(protocol);
                this.messageFacadeService.sendPushMessage(pushMessage);
                return Message.build((boolean)true, (String)"\u8d60\u9001\u6210\u529f\uff0c\u53cb\u8c0a\u66f4\u8fdb\u4e00\u6b65");
            }
        } else {
            return Message.build((boolean)false, (String)"\u60a8\u7684\u7cae\u98df\u4e0d\u8db3\uff0c\u53bb\u505a\u4efb\u52a1\u9886\u7cae\u98df\u5427~");
        }
        log.error("\u7ed9\u597d\u53cb\u589e\u52a0\u7cae\u98df\u5931\u8d25,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)param));
        return Message.build();
    }

    @Override
    public void countAndPush() {
        int monitorNum = this.imProperties.getMonitorNum();
        Date startTime = DateUtils.clearTimePart((Date)new Date());
        Date endTime = DateUtils.setField((Date)startTime, (int)11, (int)this.imProperties.getTriggerHour());
        int total = this.chatMessageMapper.sendUserCount(startTime, endTime);
        List monitorUserIds = this.chatMessageMapper.queryMonitorUserIds(startTime, endTime, monitorNum);
        StringBuilder content = new StringBuilder();
        content.append(DateUtils.formatDateTime((Date)endTime)).append("\u79c1\u804a\u60c5\u51b5\u6c47\u603b=======\n");
        content.append("0\u70b9\u81f3").append(this.imProperties.getTriggerHour()).append("\u53c2\u4e0e\u79c1\u804a\u4eba\u6570\uff1a[").append(total).append("]\n");
        content.append("0\u70b9\u81f3").append(this.imProperties.getTriggerHour()).append("\u53c2\u4e0e\u79c1\u804a\u6570\u91cf\u8d85\u8fc7").append(monitorNum).append("\u6b21\u4ee5\u4e0a\u7684\u7528\u6237\uff1a\n");
        if (monitorUserIds.size() > 0) {
            for (Long userId : monitorUserIds) {
                content.append("[").append(userId).append("]\n");
            }
        } else {
            content.append("[\u65e0]\n");
        }
        this.messageFacadeService.sendDingtalk(DingtalkMessage.builder().content(content.toString()).scene("IM").build());
    }

    public IMServiceImpl(IMSDKAdapter imsdkAdapter, RedisHashMapAdapter redisHashMapAdapter, RedisSetAdapter redisSetAdapter, UserIntegrationService userIntegrationService, UserAccountIntegrationService userAccountIntegrationService, ChatMessageMapper chatMessageMapper, ConfigClientIntegrationService clientIntegrationService, MessageFacadeService messageFacadeService, IMProperties imProperties) {
        this.imsdkAdapter = imsdkAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.userIntegrationService = userIntegrationService;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.chatMessageMapper = chatMessageMapper;
        this.clientIntegrationService = clientIntegrationService;
        this.messageFacadeService = messageFacadeService;
        this.imProperties = imProperties;
    }
}

