/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.group.impl;

import com.bxm.egg.message.utils.AdminUtils;
import com.bxm.localnews.im.domain.group.ImGroupActionHistoryMapper;
import com.bxm.localnews.im.domain.group.ImGroupBlackMapper;
import com.bxm.localnews.im.entity.group.ImGroupActionHistoryEntity;
import com.bxm.localnews.im.entity.group.ImGroupBlackEntity;
import com.bxm.localnews.im.enums.GroupActionEnum;
import com.bxm.localnews.im.group.GroupActionService;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GroupActionServiceImpl
implements GroupActionService {
    private static final Logger log = LoggerFactory.getLogger(GroupActionServiceImpl.class);
    private ImGroupBlackMapper imGroupBlackMapper;
    private ImGroupActionHistoryMapper imGroupActionHistoryMapper;

    @Override
    public Message setGroupMemberBlack(Long groupId, Long userId) {
        ImGroupBlackEntity blackEntity = new ImGroupBlackEntity();
        blackEntity.setId(SequenceHolder.nextLongId());
        blackEntity.setCreateTime(LocalDateTime.now());
        blackEntity.setEnable(Integer.valueOf(1));
        blackEntity.setGroupId(groupId);
        blackEntity.setUserId(userId);
        this.saveHistory(GroupActionEnum.KICK_OUT, groupId, blackEntity.getId(), userId);
        return Message.build((int)this.imGroupBlackMapper.insert((Object)blackEntity));
    }

    @Override
    public void saveHistory(GroupActionEnum action, Long groupId, Long relationId, Long userId) {
        ImGroupActionHistoryEntity historyEntity = new ImGroupActionHistoryEntity();
        historyEntity.setGroupId(groupId);
        historyEntity.setAction(Integer.valueOf(action.getCode()));
        historyEntity.setRelationId(relationId);
        historyEntity.setTargetUserId(userId);
        historyEntity.setCreateTime(LocalDateTime.now());
        historyEntity.setId(SequenceHolder.nextLongId());
        historyEntity.setOperator(AdminUtils.getAdminUserId());
        this.imGroupActionHistoryMapper.insert((Object)historyEntity);
    }

    public GroupActionServiceImpl(ImGroupBlackMapper imGroupBlackMapper, ImGroupActionHistoryMapper imGroupActionHistoryMapper) {
        this.imGroupBlackMapper = imGroupBlackMapper;
        this.imGroupActionHistoryMapper = imGroupActionHistoryMapper;
    }
}

