/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.group.impl;

import com.bxm.egg.common.param.BaseAreaCodeParam;
import com.bxm.egg.user.facade.service.UserEggInviteFacadeService;
import com.bxm.localnews.im.bo.GroupInfoBO;
import com.bxm.localnews.im.bo.ImGroupMemberInfoBO;
import com.bxm.localnews.im.config.IMProperties;
import com.bxm.localnews.im.convert.ImGroupConverter;
import com.bxm.localnews.im.domain.group.ImGroupMapper;
import com.bxm.localnews.im.domain.group.ImGroupMemberMapper;
import com.bxm.localnews.im.domain.group.ImGroupTotalMapper;
import com.bxm.localnews.im.dto.group.GroupNoticeDTO;
import com.bxm.localnews.im.dto.group.GroupRuntimeInfoDTO;
import com.bxm.localnews.im.dto.group.ImCrumbDTO;
import com.bxm.localnews.im.dto.group.ImGroupInfoDTO;
import com.bxm.localnews.im.entity.group.ImGroupMemberEntity;
import com.bxm.localnews.im.entity.group.ImGroupTotalEntity;
import com.bxm.localnews.im.enums.GroupStatusEnum;
import com.bxm.localnews.im.group.GroupCompositeService;
import com.bxm.localnews.im.group.GroupNoticeService;
import com.bxm.localnews.im.group.GroupService;
import com.bxm.localnews.im.param.group.BaseGroupParam;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GroupCompositeServiceImpl
implements GroupCompositeService {
    private static final Logger log = LoggerFactory.getLogger(GroupCompositeServiceImpl.class);
    private GroupNoticeService groupNoticeService;
    private ImGroupMemberMapper imGroupMemberMapper;
    private ImGroupMapper imGroupMapper;
    private IMProperties imProperties;
    private ImGroupTotalMapper imGroupTotalMapper;
    private GroupService groupService;
    private LoadingCache<String, List<String>> headImgCache;
    private UserEggInviteFacadeService userEggInviteFacadeService;

    public GroupCompositeServiceImpl(GroupNoticeService groupNoticeService, ImGroupMemberMapper imGroupMemberMapper, ImGroupMapper imGroupMapper, IMProperties imProperties, ImGroupTotalMapper imGroupTotalMapper, GroupService groupService, UserEggInviteFacadeService userEggInviteFacadeService) {
        this.groupNoticeService = groupNoticeService;
        this.imGroupMemberMapper = imGroupMemberMapper;
        this.imGroupMapper = imGroupMapper;
        this.imProperties = imProperties;
        this.imGroupTotalMapper = imGroupTotalMapper;
        this.groupService = groupService;
        this.userEggInviteFacadeService = userEggInviteFacadeService;
    }

    @PostConstruct
    private void init() {
        this.headImgCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(200L).build((CacheLoader)new CacheLoader<String, List<String>>(){

            public List<String> load(String key) throws Exception {
                List joinMemberList = GroupCompositeServiceImpl.this.imGroupMemberMapper.queryMember(null, null, null, Integer.valueOf(5));
                if (joinMemberList.size() > 0) {
                    return joinMemberList.stream().map(ImGroupMemberEntity::getHeadImg).collect(Collectors.toList());
                }
                return Lists.newArrayList();
            }
        });
    }

    @Override
    public ImGroupInfoDTO get(BaseGroupParam param) {
        ImGroupMemberEntity memberInfo = this.imGroupMemberMapper.getMemberInfo(param.getGroupId(), param.getUserId());
        if (memberInfo == null) {
            memberInfo = new ImGroupMemberEntity();
        }
        GroupNoticeDTO enableNotice = this.groupNoticeService.getEnableNotice(param.getGroupId());
        List joinMemberList = this.imGroupMemberMapper.queryActiveMember(param.getGroupId(), Integer.valueOf(19));
        ImGroupTotalEntity totalEntity = (ImGroupTotalEntity)this.imGroupTotalMapper.selectById((Serializable)param.getGroupId());
        return ImGroupInfoDTO.builder().notice(enableNotice).mute(Boolean.valueOf(Objects.equals(memberInfo.getMuted(), 1))).members(joinMemberList.stream().map(ImGroupConverter.INSTANCE::of).collect(Collectors.toList())).full(Boolean.valueOf(totalEntity.getCurrentMemberNum() >= totalEntity.getMaxMemberNum())).build();
    }

    @Override
    public ImCrumbDTO getCrumb(BaseAreaCodeParam param) {
        ImGroupMemberInfoBO userActiveGroup = this.imGroupMemberMapper.getUserActiveGroup(param.getUserId());
        boolean joinButtonVisible = null == userActiveGroup;
        String groupName = "\u672c\u5730\u6ca1\u6709\u7fa4\u7ec4";
        Long groupId = null;
        GroupRuntimeInfoDTO runtimeInfoDTO = null;
        if (null == userActiveGroup) {
            GroupRuntimeInfoDTO inviteRuntime = this.queryInviteUserGroup(param.getUserId());
            if (null != inviteRuntime) {
                groupId = inviteRuntime.getGroupId();
                groupName = inviteRuntime.getTitle();
            } else {
                List groupList = this.imGroupMapper.getEnableGroupByArea(param.getAreaCode(), param.getUserId());
                boolean hit = false;
                for (GroupInfoBO groupInfoBO : groupList) {
                    if (!GroupStatusEnum.NORMAL.match(groupInfoBO.getStatus()) || groupInfoBO.getCurrentNum() >= groupInfoBO.getMaxNum()) continue;
                    groupId = groupInfoBO.getGroupId();
                    groupName = groupInfoBO.getGroupName();
                    hit = true;
                    break;
                }
                if (!hit) {
                    for (GroupInfoBO groupInfoBO : groupList) {
                        if (!GroupStatusEnum.FULL.match(groupInfoBO.getStatus()) && groupInfoBO.getCurrentNum() < groupInfoBO.getMaxNum()) continue;
                        groupId = groupInfoBO.getGroupId();
                        groupName = groupInfoBO.getGroupName();
                        break;
                    }
                    joinButtonVisible = false;
                }
            }
        } else {
            groupId = userActiveGroup.getGroupId();
            groupName = userActiveGroup.getGroupName();
            runtimeInfoDTO = this.groupService.loadGroupRuntimeInfo(groupId);
        }
        return ImCrumbDTO.builder().groupId(groupId).groupTitle(groupName).joinButtonVisible(Boolean.valueOf(joinButtonVisible)).runtimeInfo(runtimeInfoDTO).backgroundImgUrl(this.imProperties.getCrumbImgUrl()).memberHeadImgList((List)this.headImgCache.getUnchecked((Object)param.getAreaCode())).build();
    }

    private GroupRuntimeInfoDTO queryInviteUserGroup(Long userId) {
        GroupRuntimeInfoDTO inviteUserGroupRuntimeInfo;
        ImGroupMemberInfoBO inviteUserGroup;
        Long inviteUserId = this.userEggInviteFacadeService.getInviteUserId(userId);
        if (null != inviteUserId && null != (inviteUserGroup = this.imGroupMemberMapper.getUserActiveGroup(inviteUserId)) && (inviteUserGroupRuntimeInfo = this.groupService.loadGroupRuntimeInfo(inviteUserGroup.getGroupId())).getCurrentNum() < inviteUserGroupRuntimeInfo.getTotalNum()) {
            return inviteUserGroupRuntimeInfo;
        }
        return null;
    }
}

