/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.group.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.message.dto.LocationDTO;
import com.bxm.egg.message.integration.LocationIntegrationService;
import com.bxm.egg.message.integration.UserIntegrationService;
import com.bxm.egg.message.integration.VirtualUserIntegrationService;
import com.bxm.egg.message.vo.UserInfoBean;
import com.bxm.foundation.user.facade.dto.VirtualUserDTO;
import com.bxm.localnews.im.bo.GroupInfoBO;
import com.bxm.localnews.im.domain.group.ImGroupMapper;
import com.bxm.localnews.im.domain.group.ImGroupMemberMapper;
import com.bxm.localnews.im.dto.group.GroupMemberListItemDTO;
import com.bxm.localnews.im.dto.group.GroupRuntimeInfoDTO;
import com.bxm.localnews.im.dto.group.MemberInfoDTO;
import com.bxm.localnews.im.entity.group.ImGroupEntity;
import com.bxm.localnews.im.entity.group.ImGroupMemberEntity;
import com.bxm.localnews.im.enums.GroupActionEnum;
import com.bxm.localnews.im.enums.GroupMemberStatusEnum;
import com.bxm.localnews.im.enums.GroupMemberTypeEnum;
import com.bxm.localnews.im.enums.GroupStatusEnum;
import com.bxm.localnews.im.group.GroupActionService;
import com.bxm.localnews.im.group.GroupMemberService;
import com.bxm.localnews.im.group.GroupService;
import com.bxm.localnews.im.group.GroupTotalService;
import com.bxm.localnews.im.param.group.BaseGroupParam;
import com.bxm.localnews.im.param.group.GroupMemberActionParam;
import com.bxm.localnews.im.param.group.GroupMemberQueryParam;
import com.bxm.localnews.im.param.group.GroupMuteParam;
import com.bxm.localnews.im.param.group.JoinGroupParam;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GroupMemberServiceImpl
implements GroupMemberService {
    private static final Logger log = LoggerFactory.getLogger(GroupMemberServiceImpl.class);
    private ImGroupMemberMapper imGroupMemberMapper;
    private GroupService groupService;
    private ImGroupMapper imGroupMapper;
    private UserIntegrationService userIntegrationService;
    private GroupTotalService groupTotalService;
    private IMSDKAdapter imsdkAdapter;
    private LocationIntegrationService locationIntegrationService;
    private VirtualUserIntegrationService virtualUserIntegrationService;
    private GroupActionService groupActionService;

    @Override
    public Message executeJoin(JoinGroupParam param) {
        ImGroupEntity groupEntity = this.choiceEnableGroup(param);
        if (null != groupEntity) {
            Message message = this.addMember(groupEntity.getId(), groupEntity.getName(), param.getUserId(), GroupMemberTypeEnum.NORMAL);
            if (message.isSuccess()) {
                GroupRuntimeInfoDTO runtimeInfoDTO = this.groupService.loadGroupRuntimeInfo(groupEntity.getId());
                message.addParam("grti", (Object)runtimeInfoDTO);
            }
            return message;
        }
        return Message.build((boolean)false, (String)"\u7fa4\u4eba\u6570\u5df2\u6ee1,\u8bf7\u7b49\u5f85\u7ba1\u7406\u5458\u521b\u5efa\u65b0\u7fa4");
    }

    @Override
    public Message addVirtualMember(Long groupId, String groupName, Integer num) {
        ArrayList virtualUserIdList = Lists.newArrayList();
        if (num > 1) {
            List userDTOList = this.virtualUserIntegrationService.getRandom(num);
            virtualUserIdList.addAll(userDTOList.stream().map(VirtualUserDTO::getUserId).collect(Collectors.toList()));
        }
        for (Long virtualUserId : virtualUserIdList) {
            this.addMember(groupId, groupName, virtualUserId, GroupMemberTypeEnum.VIRTUAL);
        }
        return Message.build();
    }

    private ImGroupEntity choiceEnableGroup(JoinGroupParam param) {
        ImGroupEntity groupEntity;
        if (null != param.getGroupId() && null != (groupEntity = this.groupService.getGroupEntity(param.getGroupId())) && Objects.equals(groupEntity.getStatus(), GroupStatusEnum.NORMAL.getCode()) && Objects.equals(groupEntity.getEnable(), 1)) {
            return groupEntity;
        }
        List groupList = this.imGroupMapper.getEnableGroupByArea(param.getAreaCode(), param.getUserId());
        for (GroupInfoBO groupInfoBO : groupList) {
            if (!GroupStatusEnum.NORMAL.match(groupInfoBO.getStatus()) || groupInfoBO.getCurrentNum() >= groupInfoBO.getMaxNum()) continue;
            ImGroupEntity finalGroup = new ImGroupEntity();
            finalGroup.setId(groupInfoBO.getGroupId());
            finalGroup.setName(groupInfoBO.getGroupName());
            return finalGroup;
        }
        return null;
    }

    @Override
    public Message addMember(Long groupId, String groupName, Long userId, GroupMemberTypeEnum memberType) {
        ImGroupMemberEntity memberInfo = this.imGroupMemberMapper.getMemberInfo(groupId, userId);
        if (memberInfo != null) {
            log.info("\u7528\u6237[{}]\u5df2\u7ecf\u5728[{}]\u4e2d\u4e86", (Object)userId, (Object)groupId);
            ImGroupMemberEntity updateEntity = new ImGroupMemberEntity();
            updateEntity.setId(memberInfo.getId());
            updateEntity.setStatus(Integer.valueOf(GroupMemberStatusEnum.NORAML.getCode()));
            this.imGroupMemberMapper.updateById((Object)updateEntity);
            Message message = this.imsdkAdapter.joinGroup(groupId, groupName, userId);
            if (!message.isSuccess()) {
                log.error("\u7528\u6237[{}]\u52a0\u5165\u7fa4\u804a\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)userId, (Object)message.getLastMessage());
            }
            this.groupService.reloadRuntimeCache(groupId);
            return Message.build();
        }
        Message message = this.groupTotalService.addMember(groupId);
        if (message.isSuccess()) {
            UserInfoBean userInfo = this.userIntegrationService.getUserInfo(userId);
            if (GroupMemberTypeEnum.VIRTUAL.equals((Object)memberType)) {
                userInfo = this.virtualUserIntegrationService.loadVirtualUser(userId);
            }
            ImGroupMemberEntity memberEntity = new ImGroupMemberEntity();
            memberEntity.setId(SequenceHolder.nextLongId());
            memberEntity.setGroupId(groupId);
            memberEntity.setUserId(userId);
            memberEntity.setNickName(userInfo.getNickname());
            memberEntity.setHeadImg(userInfo.getHeadImg());
            memberEntity.setUserType(Integer.valueOf(memberType.getCode()));
            memberEntity.setJoinTime(new Date());
            memberEntity.setStatus(Integer.valueOf(GroupMemberStatusEnum.NORAML.getCode()));
            this.imGroupMemberMapper.insert((Object)memberEntity);
            message = this.imsdkAdapter.joinGroup(groupId, groupName, userId);
            this.groupService.reloadRuntimeCache(groupId);
        }
        return message;
    }

    @Override
    public Message left(BaseGroupParam param) {
        ImGroupMemberEntity memberEntity = new ImGroupMemberEntity();
        memberEntity.setGroupId(param.getGroupId());
        memberEntity.setUserId(param.getUserId());
        memberEntity.setStatus(Integer.valueOf(GroupMemberStatusEnum.LEFT.getCode()));
        memberEntity.setLeftTime(new Date());
        this.imGroupMemberMapper.updateByGroupIdAndUserId(memberEntity);
        this.groupTotalService.addMember(memberEntity.getGroupId(), -1);
        return this.imsdkAdapter.quitGroup(param.getGroupId(), param.getUserId());
    }

    @Override
    public List<MemberInfoDTO> getAllMember(BaseGroupParam param) {
        return this.imGroupMemberMapper.queryAllMember(param.getGroupId());
    }

    @Override
    public Message setMute(GroupMuteParam param) {
        ImGroupMemberEntity memberEntity = new ImGroupMemberEntity();
        memberEntity.setGroupId(param.getGroupId());
        memberEntity.setUserId(param.getUserId());
        memberEntity.setMuted(Integer.valueOf(param.getMute() != false ? 1 : 0));
        return Message.build((int)this.imGroupMemberMapper.updateByGroupIdAndUserId(memberEntity));
    }

    @Override
    public IPageModel<GroupMemberListItemDTO> queryByPage(GroupMemberQueryParam param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        IPage result = this.imGroupMemberMapper.queryMemberByPage(page, param);
        for (GroupMemberListItemDTO record : result.getRecords()) {
            LocationDTO location = this.locationIntegrationService.getLocationByGeocode(record.getAreaCode());
            record.setAreaName(location.getName());
        }
        return PlusPageModelDTO.build((IPage)result);
    }

    @Override
    public Message executeMemberAction(GroupMemberActionParam param) {
        Message message = Message.build();
        GroupActionEnum actionEnum = GroupActionEnum.getByCode(param.getAction());
        if (null != actionEnum) {
            switch (actionEnum) {
                case BLOCK: {
                    return this.block(param);
                }
                case UNBLOCK: {
                    return this.unblock(param);
                }
                case KICK_OUT: {
                    return this.kickOut(param);
                }
            }
        }
        return message;
    }

    private Message unblock(GroupMemberActionParam param) {
        ImGroupMemberEntity memberEntity = (ImGroupMemberEntity)this.imGroupMemberMapper.selectById((Serializable)param.getRecordId());
        ImGroupMemberEntity updateEntity = new ImGroupMemberEntity();
        updateEntity.setId(param.getRecordId());
        updateEntity.setBlockStatus(Integer.valueOf(0));
        updateEntity.setBlockTime(null);
        updateEntity.setModifyTime(new Date());
        this.groupActionService.saveHistory(GroupActionEnum.UNBLOCK, memberEntity.getGroupId(), memberEntity.getId(), memberEntity.getUserId());
        Message message = Message.build((int)this.imGroupMemberMapper.updateById((Object)updateEntity));
        if (message.isSuccess()) {
            this.imsdkAdapter.unblockGroupMember(memberEntity.getGroupId(), memberEntity.getUserId());
        }
        return message;
    }

    private Message block(GroupMemberActionParam param) {
        ImGroupMemberEntity memberEntity = (ImGroupMemberEntity)this.imGroupMemberMapper.selectById((Serializable)param.getRecordId());
        ImGroupMemberEntity updateEntity = new ImGroupMemberEntity();
        updateEntity.setId(param.getRecordId());
        updateEntity.setBlockStatus(Integer.valueOf(1));
        if (null == param.getBlockTime()) {
            updateEntity.setBlockTime(DateUtils.addField((Date)new Date(), (int)1, (int)100));
        } else {
            updateEntity.setBlockTime(param.getBlockTime());
        }
        updateEntity.setModifyTime(new Date());
        this.groupActionService.saveHistory(GroupActionEnum.BLOCK, memberEntity.getGroupId(), memberEntity.getId(), memberEntity.getUserId());
        Message message = Message.build((int)this.imGroupMemberMapper.updateById((Object)updateEntity));
        if (message.isSuccess()) {
            this.imsdkAdapter.blockGroupMember(memberEntity.getGroupId(), memberEntity.getUserId(), updateEntity.getBlockTime());
        }
        return message;
    }

    private Message kickOut(GroupMemberActionParam param) {
        ImGroupMemberEntity memberEntity = (ImGroupMemberEntity)this.imGroupMemberMapper.selectById((Serializable)param.getRecordId());
        ImGroupMemberEntity updateEntity = new ImGroupMemberEntity();
        updateEntity.setId(param.getRecordId());
        updateEntity.setStatus(Integer.valueOf(GroupMemberStatusEnum.KICK_OUT.getCode()));
        updateEntity.setLeftTime(new Date());
        updateEntity.setModifyTime(new Date());
        this.imGroupMemberMapper.updateById((Object)updateEntity);
        this.groupTotalService.addMember(memberEntity.getGroupId(), -1);
        this.groupActionService.setGroupMemberBlack(memberEntity.getGroupId(), memberEntity.getUserId());
        return this.imsdkAdapter.quitGroup(memberEntity.getGroupId(), memberEntity.getUserId());
    }

    public GroupMemberServiceImpl(ImGroupMemberMapper imGroupMemberMapper, GroupService groupService, ImGroupMapper imGroupMapper, UserIntegrationService userIntegrationService, GroupTotalService groupTotalService, IMSDKAdapter imsdkAdapter, LocationIntegrationService locationIntegrationService, VirtualUserIntegrationService virtualUserIntegrationService, GroupActionService groupActionService) {
        this.imGroupMemberMapper = imGroupMemberMapper;
        this.groupService = groupService;
        this.imGroupMapper = imGroupMapper;
        this.userIntegrationService = userIntegrationService;
        this.groupTotalService = groupTotalService;
        this.imsdkAdapter = imsdkAdapter;
        this.locationIntegrationService = locationIntegrationService;
        this.virtualUserIntegrationService = virtualUserIntegrationService;
        this.groupActionService = groupActionService;
    }
}

