/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.group.impl;

import com.bxm.egg.message.integration.UserIntegrationService;
import com.bxm.egg.message.vo.UserInfoBean;
import com.bxm.localnews.im.config.GroupProperties;
import com.bxm.localnews.im.domain.group.ImGroupMemberMapper;
import com.bxm.localnews.im.domain.group.ImGroupNoticeMapper;
import com.bxm.localnews.im.dto.group.GroupNoticeDTO;
import com.bxm.localnews.im.entity.group.ImGroupMemberEntity;
import com.bxm.localnews.im.entity.group.ImGroupNoticeEntity;
import com.bxm.localnews.im.enums.GroupMemberTypeEnum;
import com.bxm.localnews.im.group.GroupNoticeService;
import com.bxm.localnews.im.param.group.GroupNoticeChangeParam;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.localnews.im.thirdpart.message.TextMessage;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GroupNoticeServiceImpl
implements GroupNoticeService {
    private static final Logger log = LoggerFactory.getLogger(GroupNoticeServiceImpl.class);
    private ImGroupNoticeMapper imGroupNoticeMapper;
    private IMSDKAdapter imsdkAdapter;
    private GroupProperties groupProperties;
    private ImGroupMemberMapper imGroupMemberMapper;
    private UserIntegrationService userIntegrationService;

    @Override
    public Message setNotice(GroupNoticeChangeParam param) {
        this.imGroupNoticeMapper.disableHistory(param.getGroupId());
        ImGroupNoticeEntity saveEntity = new ImGroupNoticeEntity();
        saveEntity.setId(SequenceHolder.nextLongId());
        saveEntity.setContent(param.getContent());
        saveEntity.setCreateTime(new Date());
        saveEntity.setEnable(Integer.valueOf(1));
        saveEntity.setGroupId(param.getGroupId());
        List imGroupMemberEntities = this.imGroupMemberMapper.queryMember(null, Integer.valueOf(GroupMemberTypeEnum.MANAGE.getCode()), null, Integer.valueOf(1));
        if (imGroupMemberEntities.size() > 0) {
            saveEntity.setPublisher(((ImGroupMemberEntity)imGroupMemberEntities.get(0)).getUserId());
        } else {
            saveEntity.setPublisher(this.groupProperties.getManageUserId());
        }
        this.imGroupNoticeMapper.insert((Object)saveEntity);
        return this.imsdkAdapter.sendGroupMessage(saveEntity.getGroupId(), this.groupProperties.getManageUserId(), TextMessage.builder().content(param.getContent()).build());
    }

    @Override
    public GroupNoticeDTO getEnableNotice(Long groupId) {
        ImGroupNoticeEntity enableNotice = this.imGroupNoticeMapper.getEnableNotice(groupId);
        if (null == enableNotice) {
            return null;
        }
        UserInfoBean userInfo = this.userIntegrationService.getUserInfo(enableNotice.getPublisher());
        if (log.isDebugEnabled()) {
            log.debug("\u7fa4\u7ba1\u7406\u6d88\u606f\u7684\u53d1\u5e03\u4eba\u4e3a\uff1a{} - {}", (Object)enableNotice.getPublisher(), (Object)userInfo);
        }
        return GroupNoticeDTO.builder().content(enableNotice.getContent()).publishTime(enableNotice.getCreateTime()).publisherNickName(userInfo.getNickname()).publisherHeadImg(userInfo.getHeadImg()).build();
    }

    public GroupNoticeServiceImpl(ImGroupNoticeMapper imGroupNoticeMapper, IMSDKAdapter imsdkAdapter, GroupProperties groupProperties, ImGroupMemberMapper imGroupMemberMapper, UserIntegrationService userIntegrationService) {
        this.imGroupNoticeMapper = imGroupNoticeMapper;
        this.imsdkAdapter = imsdkAdapter;
        this.groupProperties = groupProperties;
        this.imGroupMemberMapper = imGroupMemberMapper;
        this.userIntegrationService = userIntegrationService;
    }
}

