/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.group.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.message.dto.LocationDTO;
import com.bxm.egg.message.integration.LocationIntegrationService;
import com.bxm.egg.message.integration.UserIntegrationService;
import com.bxm.egg.message.vo.UserInfoBean;
import com.bxm.localnews.im.config.GroupProperties;
import com.bxm.localnews.im.config.RedPacketProperties;
import com.bxm.localnews.im.constant.ImRedisKey;
import com.bxm.localnews.im.convert.ImGroupConverter;
import com.bxm.localnews.im.domain.group.ImGroupComplainMapper;
import com.bxm.localnews.im.domain.group.ImGroupMapper;
import com.bxm.localnews.im.domain.group.ImGroupMemberMapper;
import com.bxm.localnews.im.dto.group.GroupManageListItemDTO;
import com.bxm.localnews.im.dto.group.GroupRuntimeInfoDTO;
import com.bxm.localnews.im.entity.group.ImGroupComplainEntity;
import com.bxm.localnews.im.entity.group.ImGroupEntity;
import com.bxm.localnews.im.entity.group.ImGroupMemberEntity;
import com.bxm.localnews.im.enums.GroupActionEnum;
import com.bxm.localnews.im.enums.GroupMemberTypeEnum;
import com.bxm.localnews.im.enums.GroupStatusEnum;
import com.bxm.localnews.im.group.GroupActionService;
import com.bxm.localnews.im.group.GroupMemberHeadImgService;
import com.bxm.localnews.im.group.GroupMemberService;
import com.bxm.localnews.im.group.GroupService;
import com.bxm.localnews.im.group.GroupTotalService;
import com.bxm.localnews.im.param.group.ChangeEnableParam;
import com.bxm.localnews.im.param.group.ComplainGroupParam;
import com.bxm.localnews.im.param.group.GroupManageQueryParam;
import com.bxm.localnews.im.param.group.SaveGroupParam;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GroupServiceImpl
implements GroupService {
    private static final Logger log = LoggerFactory.getLogger(GroupServiceImpl.class);
    private ImGroupMapper imGroupMapper;
    private GroupTotalService groupTotalService;
    private ImGroupComplainMapper imGroupComplainMapper;
    private IMSDKAdapter imsdkAdapter;
    private LocationIntegrationService locationIntegrationService;
    private ImGroupMemberMapper imGroupMemberMapper;
    private GroupProperties groupProperties;
    private GroupActionService groupActionService;
    private RedPacketProperties redPacketProperties;
    private RedisStringAdapter redisStringAdapter;
    private UserIntegrationService userIntegrationService;
    private GroupMemberHeadImgService groupMemberHeadImgService;

    private GroupMemberService getGroupMemberService() {
        return (GroupMemberService)SpringContextHolder.getBean(GroupMemberService.class);
    }

    @Override
    public IPageModel<GroupManageListItemDTO> query(GroupManageQueryParam param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        IPage list = this.imGroupMapper.queryByPage(page, param);
        for (GroupManageListItemDTO record : list.getRecords()) {
            LocationDTO location = this.locationIntegrationService.getLocationByGeocode(record.getAreaCode());
            record.setAreaName(location.getName());
        }
        return PlusPageModelDTO.build((IPage)list);
    }

    @Override
    public Message changeStatus(ChangeEnableParam param) {
        ImGroupEntity entity = new ImGroupEntity();
        entity.setEnable(Integer.valueOf(param.getEnable() != false ? 1 : 0));
        entity.setId(param.getGroupId());
        return Message.build((int)this.imGroupMapper.updateById((Object)entity));
    }

    @Override
    public Message changeGlobalMute(ChangeEnableParam param) {
        ImGroupEntity entity = new ImGroupEntity();
        entity.setGlobalMute(Integer.valueOf(param.getEnable() != false ? 0 : 1));
        entity.setId(param.getGroupId());
        Message message = Message.build((int)this.imGroupMapper.updateById((Object)entity));
        if (message.isSuccess()) {
            this.reloadRuntimeCache(param.getGroupId());
        }
        return message;
    }

    @Override
    public Message saveOrUpdate(SaveGroupParam param) {
        ImGroupEntity existsEntity = (ImGroupEntity)this.imGroupMapper.selectById((Serializable)param.getGroupId());
        ImGroupEntity imGroupEntity = ImGroupConverter.INSTANCE.of(param);
        Message message = Message.build();
        if (existsEntity != null) {
            this.imGroupMapper.updateById((Object)imGroupEntity);
            message = this.afterUpdate(existsEntity, imGroupEntity);
        } else {
            imGroupEntity.setStatus(Integer.valueOf(GroupStatusEnum.NORMAL.getCode()));
            imGroupEntity.setCreateTime(new Date());
            imGroupEntity.setImgUrl(this.groupProperties.getDefaultGroupImg());
            this.imGroupMapper.insert((Object)imGroupEntity);
            message.append(this.afterCreate(imGroupEntity));
        }
        this.initGroupManageUser();
        return message;
    }

    private Message afterCreate(ImGroupEntity imGroupEntity) {
        this.groupTotalService.init(imGroupEntity);
        Message message = this.imsdkAdapter.createGroup(imGroupEntity.getId(), imGroupEntity.getName(), this.groupProperties.getManageUserId(), this.redPacketProperties.getChatRoomTimingRedPacketAssistantUserId());
        if (message.isSuccess()) {
            this.getGroupMemberService().addMember(imGroupEntity.getId(), imGroupEntity.getName(), this.groupProperties.getManageUserId(), GroupMemberTypeEnum.MANAGE);
            this.getGroupMemberService().addMember(imGroupEntity.getId(), imGroupEntity.getName(), this.redPacketProperties.getChatRoomTimingRedPacketAssistantUserId(), GroupMemberTypeEnum.ACTIVITY);
            int randomNum = RandomUtils.nextInt((int)imGroupEntity.getMinVirtualNum(), (int)imGroupEntity.getMaxVirtualNum());
            message = this.getGroupMemberService().addVirtualMember(imGroupEntity.getId(), imGroupEntity.getName(), randomNum);
        }
        this.groupActionService.saveHistory(GroupActionEnum.CREATE, imGroupEntity.getId(), null, null);
        return message;
    }

    private void initGroupManageUser() {
        UserInfoBean userInfo = this.userIntegrationService.getUserInfo(this.groupProperties.getManageUserId());
        this.imsdkAdapter.update(userInfo);
        UserInfoBean redpacketUser = this.userIntegrationService.getUserInfo(this.redPacketProperties.getChatRoomTimingRedPacketAssistantUserId());
        this.imsdkAdapter.update(redpacketUser);
    }

    private Message afterUpdate(ImGroupEntity oldEntity, ImGroupEntity imGroupEntity) {
        int virtualUserTotal;
        Message message = Message.build();
        if (!Objects.equals(oldEntity.getMemberMaxNum(), imGroupEntity.getMemberMaxNum())) {
            this.groupTotalService.resetMaxMember(imGroupEntity.getId(), imGroupEntity.getMemberMaxNum());
        }
        if (!StringUtils.equals((CharSequence)oldEntity.getName(), (CharSequence)imGroupEntity.getName())) {
            message.append(this.imsdkAdapter.refreshGroup(imGroupEntity.getId(), imGroupEntity.getName()));
        }
        if ((virtualUserTotal = this.imGroupMemberMapper.countByUserType(oldEntity.getId(), Integer.valueOf(GroupMemberTypeEnum.VIRTUAL.getCode()))) > imGroupEntity.getMaxVirtualNum()) {
            List removeUserList = this.imGroupMemberMapper.queryMember(oldEntity.getId(), Integer.valueOf(GroupMemberTypeEnum.VIRTUAL.getCode()), this.groupProperties.getManageUserId(), Integer.valueOf(virtualUserTotal - imGroupEntity.getMaxVirtualNum()));
            for (ImGroupMemberEntity memberEntity : removeUserList) {
                this.imGroupMemberMapper.deleteById((Serializable)memberEntity.getId());
            }
        } else if (virtualUserTotal < imGroupEntity.getMinVirtualNum()) {
            int randomNum = RandomUtils.nextInt((int)imGroupEntity.getMinVirtualNum(), (int)imGroupEntity.getMaxVirtualNum());
            message = this.getGroupMemberService().addVirtualMember(imGroupEntity.getId(), imGroupEntity.getName(), randomNum - virtualUserTotal);
        }
        this.groupActionService.saveHistory(GroupActionEnum.MODIFY, imGroupEntity.getId(), null, null);
        this.reloadRuntimeCache(imGroupEntity.getId());
        return message;
    }

    @Override
    public Message complain(ComplainGroupParam param) {
        ImGroupComplainEntity entity = new ImGroupComplainEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setGroupId(param.getGroupId());
        entity.setContent(param.getContent());
        entity.setCreateTime(new Date());
        entity.setUserId(param.getUserId());
        return Message.build((int)this.imGroupComplainMapper.insert((Object)entity));
    }

    @Override
    public ImGroupEntity getGroupEntity(Long groupId) {
        Preconditions.checkNotNull((Object)groupId);
        return (ImGroupEntity)this.imGroupMapper.selectById((Serializable)groupId);
    }

    @Override
    public GroupRuntimeInfoDTO loadGroupRuntimeInfo(Long groupId) {
        GroupRuntimeInfoDTO runtimeInfoDTO = (GroupRuntimeInfoDTO)this.redisStringAdapter.get(ImRedisKey.GROUP_RUNTIME_CACHE_KEY.copy().appendKey((Object)groupId), GroupRuntimeInfoDTO.class);
        if (null == runtimeInfoDTO) {
            runtimeInfoDTO = this.loadToCache(groupId);
        }
        return runtimeInfoDTO;
    }

    private GroupRuntimeInfoDTO loadToCache(Long groupId) {
        GroupRuntimeInfoDTO runtimeInfoDTO = this.imGroupMapper.queryRuntimeInfo(groupId);
        int currentTrueNum = this.imGroupMemberMapper.countByUserType(groupId, Integer.valueOf(GroupMemberTypeEnum.NORMAL.getCode()));
        if (currentTrueNum < 12 && runtimeInfoDTO.getCurrentNum() < runtimeInfoDTO.getTotalNum()) {
            this.groupMemberHeadImgService.groupHeadImgSplicing(groupId);
        }
        this.redisStringAdapter.set(ImRedisKey.GROUP_RUNTIME_CACHE_KEY.copy().appendKey((Object)groupId), (Object)runtimeInfoDTO);
        return runtimeInfoDTO;
    }

    @Override
    public GroupRuntimeInfoDTO reloadRuntimeCache(Long groupId) {
        this.redisStringAdapter.remove(ImRedisKey.GROUP_RUNTIME_CACHE_KEY.copy().appendKey((Object)groupId));
        return this.loadToCache(groupId);
    }

    public GroupServiceImpl(ImGroupMapper imGroupMapper, GroupTotalService groupTotalService, ImGroupComplainMapper imGroupComplainMapper, IMSDKAdapter imsdkAdapter, LocationIntegrationService locationIntegrationService, ImGroupMemberMapper imGroupMemberMapper, GroupProperties groupProperties, GroupActionService groupActionService, RedPacketProperties redPacketProperties, RedisStringAdapter redisStringAdapter, UserIntegrationService userIntegrationService, GroupMemberHeadImgService groupMemberHeadImgService) {
        this.imGroupMapper = imGroupMapper;
        this.groupTotalService = groupTotalService;
        this.imGroupComplainMapper = imGroupComplainMapper;
        this.imsdkAdapter = imsdkAdapter;
        this.locationIntegrationService = locationIntegrationService;
        this.imGroupMemberMapper = imGroupMemberMapper;
        this.groupProperties = groupProperties;
        this.groupActionService = groupActionService;
        this.redPacketProperties = redPacketProperties;
        this.redisStringAdapter = redisStringAdapter;
        this.userIntegrationService = userIntegrationService;
        this.groupMemberHeadImgService = groupMemberHeadImgService;
    }
}

