/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.task;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.localnews.im.activity.RedPacketDetailService;
import com.bxm.localnews.im.domain.activity.RedpacketPlanDetailMapper;
import com.bxm.localnews.im.entity.activity.RedpacketPlanDetailEntity;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import java.util.List;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClearUnReceiveRedPacketTask
implements ISimplifyElasticJob {
    private static final Logger log = LoggerFactory.getLogger(ClearUnReceiveRedPacketTask.class);
    private RedpacketPlanDetailMapper redpacketPlanDetailMapper;
    private RedPacketDetailService redPacketDetailService;

    public String cron() {
        return "0 0 2 * * ?";
    }

    public String description() {
        return "\u5b9a\u671f\u6e05\u7406\u6ca1\u6709\u88ab\u9886\u53d6\u5b8c\u7684\u5468\u671f\u7ea2\u5305";
    }

    public void execute(ShardingContext shardingContext) {
        Date lastReceiveDate = DateUtils.addField((Date)new Date(), (int)5, (int)-1);
        List expiredList = this.redpacketPlanDetailMapper.getReceiveRedpacket(lastReceiveDate);
        for (RedpacketPlanDetailEntity detailEntity : expiredList) {
            log.info("[{}]\u7ea2\u5305\u672a\u9886\u53d6\u5b8c\uff0c\u5f3a\u5236\u7ed3\u675f", (Object)detailEntity.getId());
            this.redPacketDetailService.closePlanDetail(detailEntity.getId());
        }
    }

    public ClearUnReceiveRedPacketTask(RedpacketPlanDetailMapper redpacketPlanDetailMapper, RedPacketDetailService redPacketDetailService) {
        this.redpacketPlanDetailMapper = redpacketPlanDetailMapper;
        this.redPacketDetailService = redPacketDetailService;
    }
}

