/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.task;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.localnews.im.user.UserBlockService;
import com.bxm.localnews.im.vo.UserBlockBean;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UnblockTask
implements ISimplifyElasticJob {
    private static final Logger log = LoggerFactory.getLogger(UnblockTask.class);
    @Resource
    private UserBlockService userBlockService;

    public String cron() {
        return "0 0/1 * * * ?";
    }

    public String description() {
        return "\u91cd\u7f6e\u7528\u6237\u5c4f\u853d\u72b6\u6001";
    }

    public void execute(ShardingContext shardingContext) {
        List<UserBlockBean> expiredBlockList = this.userBlockService.getExpiredBlockList(new Date());
        for (UserBlockBean userBlockBean : expiredBlockList) {
            this.userBlockService.unblock(userBlockBean.getUserId());
        }
    }
}

