/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.thirdpart;

import com.bxm.localnews.im.thirdpart.MsgContentProcesser;
import com.bxm.localnews.im.thirdpart.rongcloud.DefaultProcesser;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class RCProcessorFactory
implements InitializingBean,
ApplicationContextAware {
    private static Map<String, MsgContentProcesser> processorMap = Maps.newHashMap();
    private ApplicationContext applicationContext;

    public static MsgContentProcesser get(String type) {
        MsgContentProcesser processor = processorMap.get(type);
        if (null == processor) {
            processor = new DefaultProcesser();
        }
        return processor;
    }

    public void afterPropertiesSet() {
        Map processorBeanMap = this.applicationContext.getBeansOfType(MsgContentProcesser.class);
        for (MsgContentProcesser processor : processorBeanMap.values()) {
            processorMap.put(processor.type(), processor);
        }
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

