/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.thirdpart.impl;

import com.bxm.egg.message.vo.UserInfoBean;
import com.bxm.localnews.im.config.IMProperties;
import com.bxm.localnews.im.param.MessageWithdrawParam;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.DateUtils;
import io.rong.RongCloud;
import io.rong.messages.BaseMessage;
import io.rong.models.Result;
import io.rong.models.group.GroupMember;
import io.rong.models.group.GroupModel;
import io.rong.models.message.GroupMessage;
import io.rong.models.message.PrivateMessage;
import io.rong.models.message.RecallMessage;
import io.rong.models.response.TokenResult;
import io.rong.models.user.UserModel;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class RongCloudIMSDK
implements IMSDKAdapter,
ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(RongCloudIMSDK.class);
    private RongCloud rongCloud;
    private final IMProperties imProperties;
    private static final int MAX_MUTE_MINUTES = 43200;

    @Autowired
    public RongCloudIMSDK(IMProperties imProperties) {
        this.imProperties = imProperties;
    }

    @Override
    public String token(UserInfoBean user) {
        UserModel model = this.build(user);
        TokenResult token = this.applyWithResult(() -> this.rongCloud.user.register(model));
        if (token == null) {
            return null;
        }
        return token.getToken();
    }

    private UserModel build(UserInfoBean user) {
        return new UserModel(user.getId().toString(), user.getNickname(), user.getHeadImg());
    }

    @Override
    public void update(UserInfoBean user) {
        UserModel model = this.build(user);
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u4fe1\u606f\u53d8\u66f4\uff0c\u540c\u6b65\u53d8\u66f4\u4fe1\u606f,\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)model);
        }
        this.apply(() -> this.rongCloud.user.update(model));
    }

    @Override
    public Message block(Long userId, int minutes) {
        UserModel user = new UserModel();
        user.setMinute(Integer.valueOf(minutes));
        user.setId(String.valueOf(userId));
        return this.apply(() -> this.rongCloud.user.block.add(user));
    }

    @Override
    public Message unblock(Long userId) {
        return this.apply(() -> this.rongCloud.user.block.remove(String.valueOf(userId)));
    }

    @Override
    public Message messageWithdraw(MessageWithdrawParam param) {
        RecallMessage recallMessage = new RecallMessage().setSenderId(String.valueOf(param.getFromUserId())).setTargetId(param.getTargetId()).setuId(param.getMessageUID()).setSentTime(String.valueOf(System.currentTimeMillis()));
        recallMessage.setIsAdmin(Integer.valueOf(1));
        return this.apply(() -> this.rongCloud.message.chatroom.recall(recallMessage));
    }

    @Override
    public Message batchSendPersonalMessage(PrivateMessage message) {
        return this.apply(() -> this.rongCloud.message.msgPrivate.send(message));
    }

    @Override
    public Message createGroup(Long groupId, String name, Long ... manageMember) {
        GroupModel groupModel = new GroupModel();
        groupModel.setId(groupId.toString());
        groupModel.setName(name);
        groupModel.setMembers(this.buildGroupMember(groupId, manageMember));
        return this.apply(() -> this.rongCloud.group.create(groupModel));
    }

    @Override
    public Message refreshGroup(Long groupId, String name) {
        GroupModel groupModel = new GroupModel();
        groupModel.setId(groupId.toString());
        groupModel.setName(name);
        return this.apply(() -> this.rongCloud.group.update(groupModel));
    }

    @Override
    public Message joinGroup(Long groupId, String groupName, Long ... memberIds) {
        GroupModel groupModel = new GroupModel();
        groupModel.setId(groupId.toString());
        groupModel.setName(groupName);
        groupModel.setMembers(this.buildGroupMember(groupId, memberIds));
        return this.apply(() -> this.rongCloud.group.join(groupModel));
    }

    private GroupMember[] buildGroupMember(Long groupId, Long ... memberIds) {
        GroupMember[] memberArray = new GroupMember[memberIds.length];
        for (int i = 0; i < memberIds.length; ++i) {
            memberArray[i] = new GroupMember(memberIds[0].toString(), groupId.toString(), Integer.valueOf(0));
        }
        return memberArray;
    }

    @Override
    public Message quitGroup(Long groupId, Long ... memberIds) {
        GroupModel groupModel = new GroupModel();
        groupModel.setId(groupId.toString());
        groupModel.setMembers(this.buildGroupMember(groupId, memberIds));
        return this.apply(() -> this.rongCloud.group.quit(groupModel));
    }

    @Override
    public Message blockGroupMember(Long groupId, Long memberId, Date blockDate) {
        long minutes = DateUtils.getDiffMinutes((Date)blockDate, (Date)new Date(), (boolean)true);
        if (minutes > 43200L) {
            minutes = 0L;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u7fa4\u6210\u5458\u7981\u8a00\uff0c\u7fa4\u7ec4\uff1a{},memberId: {} ,blockMinutes: {}", new Object[]{groupId, memberId, minutes});
        }
        GroupMember member = new GroupMember();
        member.setGroupId(groupId.toString());
        member.setId(memberId.toString());
        member.setMunite(Integer.valueOf((int)minutes));
        GroupModel groupModel = new GroupModel();
        groupModel.setId(groupId.toString());
        groupModel.setMembers(new GroupMember[]{member});
        groupModel.setMinute(Integer.valueOf((int)minutes));
        return this.apply(() -> this.rongCloud.group.muteMembers.add(groupModel));
    }

    @Override
    public Message unblockGroupMember(Long groupId, Long memberId) {
        if (log.isDebugEnabled()) {
            log.debug("\u89e3\u9664\u7fa4\u7ec4\u7981\u8a00\uff1a{} - {} ", (Object)groupId, (Object)memberId);
        }
        GroupModel groupModel = new GroupModel();
        groupModel.setId(groupId.toString());
        groupModel.setMembers(this.buildGroupMember(groupId, memberId));
        return this.apply(() -> this.rongCloud.group.muteMembers.remove(groupModel));
    }

    @Override
    public Message sendGroupMessage(Long groupId, Long forumId, BaseMessage baseMessage) {
        if (log.isDebugEnabled()) {
            log.debug("\u53d1\u9001\u6d88\u606f\u5230\u7fa4\u7ec4[{}],\u53d1\u9001\u4eba:[{}],\u6d88\u606f\u5185\u5bb9\uff1a[{}]", new Object[]{groupId, forumId, JSON.toJSONString((Object)baseMessage)});
        }
        GroupMessage message = new GroupMessage();
        message.setContent(baseMessage);
        message.setObjectName(message.getContent().getType());
        message.setSenderId(forumId.toString());
        message.setTargetId(new String[]{groupId.toString()});
        return this.apply(() -> this.rongCloud.message.group.send(message));
    }

    private Message apply(ExecuteRongCloudFunction<Result> function) {
        Message message = Message.build();
        try {
            Result result = function.apply();
            if (null != result && HttpStatus.OK.value() == result.getCode().intValue()) {
                return message;
            }
            log.error("\u6267\u884c\u878d\u4e91\u7684\u8fdc\u7a0b\u8c03\u7528\u5931\u8d25\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)result));
            message.setSuccess(false).setMessage("\u8c03\u7528\u878d\u4e91\u7684\u670d\u52a1\u5931\u8d25");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            message = Message.build((boolean)false, (String)e.getMessage());
        }
        return message;
    }

    private <T> T applyWithResult(ExecuteRongCloudFunction<T> function) {
        try {
            return function.apply();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        if (null != this.imProperties.getRongcloudAppKey() && null != this.imProperties.getRongcloudAppSecret()) {
            this.rongCloud = RongCloud.getInstance((String)this.imProperties.getRongcloudAppKey(), (String)this.imProperties.getRongcloudAppSecret());
        } else {
            log.error("\u672a\u914d\u7f6e\u878d\u4e91\u7684\u76f8\u5173\u4fe1\u606f");
        }
    }

    @FunctionalInterface
    static interface ExecuteRongCloudFunction<T> {
        public T apply() throws Exception;
    }
}

