/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.user.impl;

import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.message.utils.AdminUtils;
import com.bxm.localnews.im.domain.UserBlockMapper;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.localnews.im.user.UserBlockService;
import com.bxm.localnews.im.vo.UserBlockBean;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserBlockServiceImpl
implements UserBlockService {
    private static final Logger log = LoggerFactory.getLogger(UserBlockServiceImpl.class);
    @Resource
    private UserBlockMapper userBlockMapper;
    @Resource
    private IMSDKAdapter imsdkAdapter;
    @Resource
    private MessageFacadeService messageFacadeService;
    @Resource
    private SequenceCreater sequenceCreate;

    @Override
    public Message add(Long userId, Long blockUserId) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((blockUserId != null ? 1 : 0) != 0);
        UserBlockBean entity = UserBlockBean.builder().id(this.sequenceCreate.nextLongId()).blockUserId(blockUserId).userId(userId).status(Byte.valueOf((byte)1)).createTime(new Date()).build();
        return Message.build((int)this.userBlockMapper.insert(entity));
    }

    @Override
    public Message cancel(Long userId, Long blockUserId) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((blockUserId != null ? 1 : 0) != 0);
        return Message.build((int)this.userBlockMapper.cancel(userId, blockUserId));
    }

    @Override
    public Message block(Long userId, int minutes) {
        if (null == userId || minutes <= 0) {
            return Message.build((boolean)false, (String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        }
        Message message = this.imsdkAdapter.block(userId, minutes);
        if (message.isSuccess()) {
            log.debug("\u6dfb\u52a0\u5b9a\u65f6\u89e3\u5c01\u4efb\u52a1\uff0c\u7528\u6237ID\uff1a[{}]\uff0c\u5c01\u7981\u65f6\u957f\uff1a[{}]", (Object)userId, (Object)minutes);
            UserBlockBean entity = UserBlockBean.builder().id(this.sequenceCreate.nextLongId()).userId(AdminUtils.getAdminUserId()).blockUserId(userId).status(Byte.valueOf((byte)1)).createTime(new Date()).expiredTime(DateUtils.addField((Date)new Date(), (int)12, (int)minutes)).build();
            this.userBlockMapper.insert(entity);
        }
        return message;
    }

    @Override
    public Message unblock(Long userId) {
        if (null == userId) {
            return Message.build((boolean)false, (String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        }
        Message message = this.imsdkAdapter.unblock(userId);
        if (message.isSuccess()) {
            this.userBlockMapper.unblock(userId);
        }
        return message;
    }

    @Override
    public List<UserBlockBean> getExpiredBlockList(Date expiredTime) {
        return this.userBlockMapper.getExpiredBlockList(expiredTime);
    }
}

