/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.user.impl;

import com.bxm.egg.common.constant.InfoCombineStateEnum;
import com.bxm.egg.message.integration.UserIntegrationService;
import com.bxm.localnews.im.config.IMProperties;
import com.bxm.localnews.im.constant.ImRedisKey;
import com.bxm.localnews.im.domain.ChatMessageMapper;
import com.bxm.localnews.im.dto.SessionInfoDto;
import com.bxm.localnews.im.user.UserService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    private final UserIntegrationService userIntegrationService;
    private final ChatMessageMapper chatMessageMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final IMProperties imProperties;
    private final RedisSetAdapter redisSetAdapter;
    private static final int MAX_SEND_MSG = 2;

    @Autowired
    public UserServiceImpl(UserIntegrationService userIntegrationService, ChatMessageMapper chatMessageMapper, RedisHashMapAdapter redisHashMapAdapter, IMProperties imProperties, RedisSetAdapter redisSetAdapter) {
        this.userIntegrationService = userIntegrationService;
        this.chatMessageMapper = chatMessageMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.imProperties = imProperties;
        this.redisSetAdapter = redisSetAdapter;
    }

    @Override
    public SessionInfoDto get(Long fromUid, Long toUid, Boolean consumePromptGuide) {
        SessionInfoDto session = new SessionInfoDto();
        session.setFollow(this.userIntegrationService.isFollow(fromUid, toUid));
        session.setFollowMe(this.userIntegrationService.isFollow(toUid, fromUid));
        session.setTargetUser(this.userIntegrationService.getUserInfo(toUid));
        session.setAllowSend(Boolean.valueOf(true));
        if (this.imProperties.getWhiteList().contains(fromUid)) {
            session.setAllowSendMedia(Boolean.valueOf(true));
        } else if (session.getFollowMe().booleanValue()) {
            session.setFollowMsg(this.userIntegrationService.hasFollowMsg(fromUid, toUid));
            session.setAllowSendMedia(Boolean.valueOf(true));
        } else {
            Integer reply = this.chatMessageMapper.hasReply(fromUid, toUid);
            if (null == reply || 0 == reply) {
                Long sendMsgNum = (Long)this.redisHashMapAdapter.get(this.buildKey(toUid), String.valueOf(fromUid), Long.class);
                if (null != sendMsgNum && sendMsgNum >= 2L) {
                    session.setAllowSend(Boolean.valueOf(false));
                    session.setRejectMsg("\u5bf9\u65b9\u8fd8\u6ca1\u6709\u5173\u6ce8\u4f60\uff0c\u5728\u672a\u6536\u5230\u56de\u590d\u524d\u4e0d\u80fd\u518d\u7ee7\u7eed\u53d1\u6d88\u606f\u4e86");
                    log.debug("session:{},sendMsgNum:{}", (Object)session, (Object)sendMsgNum);
                }
            } else {
                session.setAllowSendMedia(Boolean.valueOf(true));
            }
        }
        if (Objects.nonNull(consumePromptGuide) && consumePromptGuide.booleanValue()) {
            Long infoCompleteState;
            String value = Long.toHexString(fromUid) + Long.toHexString(toUid);
            if (!this.redisSetAdapter.exists(ImRedisKey.SHOW_INFO_COMPLETE_GUIDE_FLAG.copy(), (Object)value).booleanValue() && Objects.nonNull(infoCompleteState = this.userIntegrationService.getInfoCompleteState(fromUid))) {
                int infoCompletePercent = InfoCombineStateEnum.getInfoCompletePercent((Long)infoCompleteState);
                if (this.imProperties.getNativeNewbieGuideThreshold() > infoCompletePercent) {
                    session.setShowInfoCompleteGuideFlag(Boolean.valueOf(true));
                    this.redisSetAdapter.add(ImRedisKey.SHOW_INFO_COMPLETE_GUIDE_FLAG.copy(), new Object[]{value});
                }
            }
        }
        return session;
    }

    private KeyGenerator buildKey(Long userId) {
        return ImRedisKey.UN_READ_MSG.copy().appendKey((Object)userId);
    }
}

