/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.utils;

import com.bxm.newidea.component.oss.service.AliyunOSSService;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MakeGroupHeadPicUtil {
    private static final Logger log = LoggerFactory.getLogger(MakeGroupHeadPicUtil.class);
    @Resource
    private AliyunOSSService aliyunOSSService;
    private final Integer PIC_WIDTH = 422;
    private final Integer PIC_HEIGHT = 422;
    private final Integer PIC_SPACE = 14;
    private Double LUMP_WIDTH = null;
    private Double LUMP_POINT_X = null;
    private Double LUMP_POINT_Y = null;
    private final int[] COLOR_GREY_BGR = new int[]{230, 230, 230};
    private int flg = 0;

    public String uploadImgToOssBySrc(String src, String fileName) {
        try {
            File file = new File(src);
            return this.aliyunOSSService.upload(file, fileName);
        }
        catch (Exception e) {
            log.error("\u7b2c\u4e09\u65b9\u56fe\u7247\u4e0a\u4f20\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public String getCombinationOfhead(List<String> pics, String fileName) {
        ArrayList<BufferedImage> bufferedImages = new ArrayList<BufferedImage>();
        BufferedImage outImage = new BufferedImage(this.PIC_WIDTH, this.PIC_HEIGHT, 1);
        Graphics2D gra = outImage.createGraphics();
        gra.setColor(this.toColor(this.COLOR_GREY_BGR));
        gra.fillRect(0, 0, this.PIC_WIDTH, this.PIC_HEIGHT);
        Integer size = pics.size();
        Integer sqrt = (int)Math.ceil(Math.sqrt(size.intValue()));
        this.LUMP_WIDTH = ((double)this.PIC_WIDTH.intValue() - ((double)sqrt.intValue() + 1.0) * (double)this.PIC_SPACE.intValue()) / (double)sqrt.intValue();
        for (String pic : pics) {
            BufferedImage resize2 = this.resize2(pic, this.LUMP_WIDTH.intValue(), this.LUMP_WIDTH.intValue(), true);
            bufferedImages.add(resize2);
        }
        int lack = 0;
        if (size < sqrt * (sqrt - 1)) {
            lack = sqrt * (sqrt - 1) - size;
            this.LUMP_POINT_X = this.PIC_SPACE.doubleValue() + (double)lack * (this.LUMP_WIDTH + (double)this.PIC_SPACE.intValue()) / 2.0;
            this.LUMP_POINT_Y = this.PIC_SPACE.doubleValue() + this.LUMP_WIDTH / 2.0;
        } else if (size == sqrt * (sqrt - 1)) {
            this.LUMP_POINT_X = this.PIC_SPACE.doubleValue();
            this.LUMP_POINT_Y = this.PIC_SPACE.doubleValue() + this.LUMP_WIDTH / 2.0;
        } else if (size < sqrt * sqrt) {
            lack = sqrt * sqrt - size;
            this.LUMP_POINT_X = this.PIC_SPACE.doubleValue() + (double)lack * (this.LUMP_WIDTH + (double)this.PIC_SPACE.intValue()) / 2.0;
            this.LUMP_POINT_Y = this.PIC_SPACE.doubleValue();
        } else if (size == sqrt * sqrt) {
            this.LUMP_POINT_X = this.PIC_SPACE.doubleValue();
            this.LUMP_POINT_Y = this.PIC_SPACE.doubleValue();
        }
        int line = lack == 0 ? -1 : 0;
        int row = 0;
        for (int i = 0; i < bufferedImages.size(); ++i) {
            if ((i + lack) % sqrt == 0) {
                ++line;
                row = 0;
            }
            if (line == 0) {
                gra.drawImage((Image)bufferedImages.get(i), this.LUMP_POINT_X.intValue() + row++ * (this.PIC_SPACE + this.LUMP_WIDTH.intValue()), this.LUMP_POINT_Y.intValue(), null);
                continue;
            }
            gra.drawImage((Image)bufferedImages.get(i), this.PIC_SPACE + row++ * (this.PIC_SPACE + this.LUMP_WIDTH.intValue()), this.LUMP_POINT_Y.intValue() + line * (this.PIC_SPACE + this.LUMP_WIDTH.intValue()), null);
        }
        String targetDirectory = null;
        File file = null;
        try {
            File sysTempDir = new File(System.getProperty("java.io.tmpdir"));
            targetDirectory = sysTempDir.getCanonicalPath();
            file = new File(targetDirectory + fileName + ".png");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
                if (file.exists()) {
                    file.delete();
                    if (!file.createNewFile()) {
                        log.error("\u521b\u5efa\u5931\u8d25\uff01");
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u5931\u8d25\uff01", (Throwable)e);
        }
        try {
            ImageIO.write((RenderedImage)outImage, "png", file);
            return this.uploadImgToOssBySrc(targetDirectory + fileName + ".png", fileName);
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    private BufferedImage resize2(String picPath, Integer height, Integer width, boolean fill) {
        try {
            BufferedImage imageBuff = null;
            imageBuff = picPath.indexOf("https://") == 0 || picPath.indexOf("http://") == 0 ? ImageIO.read(new URL(picPath)) : ImageIO.read(new File(picPath));
            Image itemp = imageBuff.getScaledInstance(width, height, 4);
            double ratio = 0.0;
            if (imageBuff.getHeight() > height || imageBuff.getWidth() > width) {
                ratio = imageBuff.getHeight() > imageBuff.getWidth() ? height.doubleValue() / (double)imageBuff.getHeight() : width.doubleValue() / (double)imageBuff.getWidth();
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
                itemp = op.filter(imageBuff, null);
            }
            if (fill) {
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                g.setColor(this.toColor(this.COLOR_GREY_BGR));
                g.fillRect(0, 0, width, height);
                if (width.intValue() == itemp.getWidth(null)) {
                    g.drawImage(itemp, 0, (height - itemp.getHeight(null)) / 2, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                } else {
                    g.drawImage(itemp, (width - itemp.getWidth(null)) / 2, 0, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                }
                g.dispose();
                itemp = image;
            }
            return (BufferedImage)itemp;
        }
        catch (IOException e) {
            log.error("\u89e3\u6790\u56fe\u7247\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    private Color toColor(int[] colorRoot) {
        if (colorRoot.length >= 3) {
            return new Color(colorRoot[0], colorRoot[1], colorRoot[2]);
        }
        return null;
    }
}

