package com.bxm.egg.user.event.config;

import com.bxm.egg.user.event.stream.MessageProcessor;
import com.bxm.egg.user.event.subscribe.UserActionStreamSubscriber;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * 用户行为相关配置
 *
 * @author liujia
 * @date 2020-07-16 14:22
 **/
@Configuration
@EnableBinding(MessageProcessor.class)
public class UserActionConfiguration {

    /**
     * 创建一个异步的用户行为事件队列
     *
     * @return 事件队列
     */
    @Bean
    public EventBus userActionEventBus(UserActionStreamSubscriber userActionStreamSubscriber) {
        EventBus eventBus = new AsyncEventBus("userActionEventBus", userActionThreadPool());

        eventBus.register(userActionStreamSubscriber);

        return eventBus;
    }

    @Bean
    public ThreadPoolTaskExecutor userActionThreadPool() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(5);
        taskExecutor.setQueueCapacity(5000);
        taskExecutor.setMaxPoolSize(50);
        taskExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        taskExecutor.setThreadFactory(new NamedThreadFactory("user-action-task"));
        taskExecutor.initialize();

        return taskExecutor;
    }
}
