/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.utils;

import java.time.LocalDate;
import java.util.Objects;

public class ConstellationUtils {
    private static final Constellation[] CONSTELLATIONS = new Constellation[]{Constellation.Aquarius, Constellation.Pisces, Constellation.Aries, Constellation.Taurus, Constellation.Gemini, Constellation.Cancer, Constellation.Leo, Constellation.Virgo, Constellation.Libra, Constellation.Scorpio, Constellation.Sagittarius, Constellation.Capricorn};
    private static final int[] CONSTELLATION_EDGE_DAY = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};

    public static String calculateConstellation(LocalDate birthday) {
        if (Objects.nonNull(birthday)) {
            int month;
            int day = birthday.getDayOfMonth();
            month = day < CONSTELLATION_EDGE_DAY[(month = birthday.getMonthValue()) - 1] ? month - 1 : month;
            return month > 0 ? CONSTELLATIONS[month - 1].getChineseName() : CONSTELLATIONS[11].getChineseName();
        }
        return null;
    }

    public static enum Constellation {
        Capricorn(1, "\u6469\u7faf\u5ea7"),
        Aquarius(2, "\u6c34\u74f6\u5ea7"),
        Pisces(3, "\u53cc\u9c7c\u5ea7"),
        Aries(4, "\u767d\u7f8a\u5ea7"),
        Taurus(5, "\u91d1\u725b\u5ea7"),
        Gemini(6, "\u53cc\u5b50\u5ea7"),
        Cancer(7, "\u5de8\u87f9\u5ea7"),
        Leo(8, "\u72ee\u5b50\u5ea7"),
        Virgo(9, "\u5904\u5973\u5ea7"),
        Libra(10, "\u5929\u79e4\u5ea7"),
        Scorpio(11, "\u5929\u874e\u5ea7"),
        Sagittarius(12, "\u5c04\u624b\u5ea7");

        private int code;
        private String chineseName;

        private Constellation(int code, String chineseName) {
            this.code = code;
            this.chineseName = chineseName;
        }

        public int getCode() {
            return this.code;
        }

        public String getChineseName() {
            return this.chineseName;
        }
    }
}

