/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.mock;

import com.bxm.egg.common.enums.UserStatusEnum;
import com.bxm.egg.user.bo.UserInfoBO;
import com.bxm.egg.user.bo.UserStatisticsBO;
import com.bxm.egg.user.service.UserInfoFacadeService;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class UserInfoFacadeServiceMock
implements UserInfoFacadeService {
    private static final Logger log = LoggerFactory.getLogger(UserInfoFacadeServiceMock.class);

    @Override
    public UserInfoBO selectUserFromCache(Long userId) {
        log.error("\u67e5\u8be2\u7528\u6237\u7f13\u5b58\u4fe1\u606f\u5931\u8d25, \u7528\u6237id\uff1a{}", (Object)userId);
        return this.buildInvalidUserCacheInfo(userId);
    }

    @Override
    public List<UserInfoBO> selectUserListFromCache(List<Long> userIdList) {
        log.error("\u6279\u91cf\u67e5\u8be2\u7528\u6237\u7f13\u5b58\u4fe1\u606f\u5931\u8d25, \u7528\u6237id\uff1a{}", userIdList);
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.EMPTY_LIST;
        }
        return userIdList.stream().map(this::buildInvalidUserCacheInfo).collect(Collectors.toList());
    }

    @Override
    public UserStatisticsBO getUserStatisticsInfo(Long userId) {
        log.error("\u67e5\u8be2\u7528\u6237\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25, \u7528\u6237id\uff1a{}", (Object)userId);
        UserStatisticsBO userStatisticsBO = new UserStatisticsBO();
        userStatisticsBO.setPostNum(0);
        userStatisticsBO.setReplyNum(0);
        userStatisticsBO.setAttentionNum(0);
        userStatisticsBO.setFanNum(0);
        userStatisticsBO.setLikeNum(0);
        return userStatisticsBO;
    }

    @Override
    public Long getInfoCompleteState(Long userId) {
        log.error("\u67e5\u8be2\u7528\u6237\u8d44\u6599\u5b8c\u6210\u5ea6\u4fe1\u606f\u5931\u8d25, \u7528\u6237id\uff1a{}", (Object)userId);
        return 0L;
    }

    private UserInfoBO buildInvalidUserCacheInfo(Long userId) {
        UserInfoBO userCacheInfoBO = new UserInfoBO();
        userCacheInfoBO.setHeadImg("http://bxm-news.oss-cn-hangzhou.aliyuncs.com/img/defaultHeadImg.jpeg");
        userCacheInfoBO.setUserId(userId);
        userCacheInfoBO.setNickname("\u672a\u77e5\u7528\u6237");
        userCacheInfoBO.setState(UserStatusEnum.DISABLE.getCode());
        return userCacheInfoBO;
    }
}

